/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.util.atomic;

import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReferenceArray;
import rx.internal.util.atomic.AtomicReferenceArrayQueue;

public final class SpscAtomicArrayQueue<E>
extends AtomicReferenceArrayQueue<E> {
    private static final Integer MAX_LOOK_AHEAD_STEP = Integer.getInteger("jctools.spsc.max.lookahead.step", 4096);
    final AtomicLong producerIndex = new AtomicLong();
    long producerLookAhead;
    final AtomicLong consumerIndex = new AtomicLong();
    final int lookAheadStep;

    public SpscAtomicArrayQueue(int capacity) {
        super(capacity);
        this.lookAheadStep = Math.min(capacity / 4, MAX_LOOK_AHEAD_STEP);
    }

    @Override
    public boolean offer(E e2) {
        if (null == e2) {
            throw new NullPointerException("Null is not a valid element");
        }
        AtomicReferenceArray buffer = this.buffer;
        int mask = this.mask;
        long index2 = this.producerIndex.get();
        int offset = this.calcElementOffset(index2, mask);
        if (index2 >= this.producerLookAhead) {
            int step = this.lookAheadStep;
            if (null == this.lvElement(buffer, this.calcElementOffset(index2 + (long)step, mask))) {
                this.producerLookAhead = index2 + (long)step;
            } else if (null != this.lvElement(buffer, offset)) {
                return false;
            }
        }
        this.soElement(buffer, offset, e2);
        this.soProducerIndex(index2 + 1L);
        return true;
    }

    @Override
    public E poll() {
        AtomicReferenceArray lElementBuffer = this.buffer;
        long index2 = this.consumerIndex.get();
        int offset = this.calcElementOffset(index2);
        Object e2 = this.lvElement(lElementBuffer, offset);
        if (null == e2) {
            return null;
        }
        this.soElement(lElementBuffer, offset, null);
        this.soConsumerIndex(index2 + 1L);
        return e2;
    }

    @Override
    public E peek() {
        return this.lvElement(this.calcElementOffset(this.consumerIndex.get()));
    }

    @Override
    public int size() {
        long currentProducerIndex;
        long before;
        long after = this.lvConsumerIndex();
        do {
            before = after;
            currentProducerIndex = this.lvProducerIndex();
        } while (before != (after = this.lvConsumerIndex()));
        return (int)(currentProducerIndex - after);
    }

    @Override
    public boolean isEmpty() {
        return this.lvProducerIndex() == this.lvConsumerIndex();
    }

    private void soProducerIndex(long newIndex) {
        this.producerIndex.lazySet(newIndex);
    }

    private void soConsumerIndex(long newIndex) {
        this.consumerIndex.lazySet(newIndex);
    }

    private long lvConsumerIndex() {
        return this.consumerIndex.get();
    }

    private long lvProducerIndex() {
        return this.producerIndex.get();
    }
}

