/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.util;

import java.util.Queue;
import rx.Observer;
import rx.Subscription;
import rx.exceptions.MissingBackpressureException;
import rx.internal.operators.NotificationLite;
import rx.internal.util.PlatformDependent;
import rx.internal.util.atomic.SpscAtomicArrayQueue;
import rx.internal.util.unsafe.SpmcArrayQueue;
import rx.internal.util.unsafe.SpscArrayQueue;
import rx.internal.util.unsafe.UnsafeAccess;

public class RxRingBuffer
implements Subscription {
    private Queue<Object> queue;
    private final int size;
    public volatile Object terminalState;
    public static final int SIZE;

    public static RxRingBuffer getSpscInstance() {
        if (UnsafeAccess.isUnsafeAvailable()) {
            return new RxRingBuffer(false, SIZE);
        }
        return new RxRingBuffer();
    }

    public static RxRingBuffer getSpmcInstance() {
        if (UnsafeAccess.isUnsafeAvailable()) {
            return new RxRingBuffer(true, SIZE);
        }
        return new RxRingBuffer();
    }

    private RxRingBuffer(Queue<Object> queue2, int size) {
        this.queue = queue2;
        this.size = size;
    }

    private RxRingBuffer(boolean spmc, int size) {
        this.queue = spmc ? new SpmcArrayQueue(size) : new SpscArrayQueue(size);
        this.size = size;
    }

    public synchronized void release() {
    }

    @Override
    public void unsubscribe() {
        this.release();
    }

    RxRingBuffer() {
        this(new SpscAtomicArrayQueue<Object>(SIZE), SIZE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onNext(Object o) throws MissingBackpressureException {
        boolean iae = false;
        boolean mbe = false;
        RxRingBuffer rxRingBuffer = this;
        synchronized (rxRingBuffer) {
            Queue<Object> q = this.queue;
            if (q != null) {
                mbe = !q.offer(NotificationLite.next(o));
            } else {
                iae = true;
            }
        }
        if (iae) {
            throw new IllegalStateException("This instance has been unsubscribed and the queue is no longer usable.");
        }
        if (mbe) {
            throw new MissingBackpressureException();
        }
    }

    public void onCompleted() {
        if (this.terminalState == null) {
            this.terminalState = NotificationLite.completed();
        }
    }

    public void onError(Throwable t3) {
        if (this.terminalState == null) {
            this.terminalState = NotificationLite.error(t3);
        }
    }

    public int available() {
        return this.size - this.count();
    }

    public int capacity() {
        return this.size;
    }

    public int count() {
        Queue<Object> q = this.queue;
        if (q == null) {
            return 0;
        }
        return q.size();
    }

    public boolean isEmpty() {
        Queue<Object> q = this.queue;
        return q == null || q.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object poll() {
        Object o;
        RxRingBuffer rxRingBuffer = this;
        synchronized (rxRingBuffer) {
            Queue<Object> q = this.queue;
            if (q == null) {
                return null;
            }
            o = q.poll();
            Object ts = this.terminalState;
            if (o == null && ts != null && q.peek() == null) {
                o = ts;
                this.terminalState = null;
            }
        }
        return o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object peek() {
        Object o;
        RxRingBuffer rxRingBuffer = this;
        synchronized (rxRingBuffer) {
            Queue<Object> q = this.queue;
            if (q == null) {
                return null;
            }
            o = q.peek();
            Object ts = this.terminalState;
            if (o == null && ts != null && q.peek() == null) {
                o = ts;
            }
        }
        return o;
    }

    public boolean isCompleted(Object o) {
        return NotificationLite.isCompleted(o);
    }

    public boolean isError(Object o) {
        return NotificationLite.isError(o);
    }

    public Object getValue(Object o) {
        return NotificationLite.getValue(o);
    }

    public boolean accept(Object o, Observer child) {
        return NotificationLite.accept(child, o);
    }

    public Throwable asError(Object o) {
        return NotificationLite.getError(o);
    }

    @Override
    public boolean isUnsubscribed() {
        return this.queue == null;
    }

    static {
        String sizeFromProperty;
        int defaultSize = 128;
        if (PlatformDependent.isAndroid()) {
            defaultSize = 16;
        }
        if ((sizeFromProperty = System.getProperty("rx.ring-buffer.size")) != null) {
            try {
                defaultSize = Integer.parseInt(sizeFromProperty);
            }
            catch (NumberFormatException e2) {
                System.err.println("Failed to set 'rx.buffer.size' with value " + sizeFromProperty + " => " + e2.getMessage());
            }
        }
        SIZE = defaultSize;
    }
}

