/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.util;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicReference;
import rx.exceptions.CompositeException;

public enum ExceptionsUtils {

    private static final Throwable TERMINATED = new Throwable("Terminated");

    public static boolean addThrowable(AtomicReference<Throwable> field, Throwable error2) {
        Throwable next2;
        Throwable current;
        do {
            if ((current = field.get()) == TERMINATED) {
                return false;
            }
            if (current == null) {
                next2 = error2;
                continue;
            }
            if (current instanceof CompositeException) {
                ArrayList<Throwable> list = new ArrayList<Throwable>(((CompositeException)current).getExceptions());
                list.add(error2);
                next2 = new CompositeException(list);
                continue;
            }
            next2 = new CompositeException(current, error2);
        } while (!field.compareAndSet(current, next2));
        return true;
    }

    public static Throwable terminate(AtomicReference<Throwable> field) {
        Throwable current = field.get();
        if (current != TERMINATED) {
            current = field.getAndSet(TERMINATED);
        }
        return current;
    }

    public static boolean isTerminated(AtomicReference<Throwable> field) {
        return ExceptionsUtils.isTerminated(field.get());
    }

    public static boolean isTerminated(Throwable error2) {
        return error2 == TERMINATED;
    }
}

