/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.schedulers;

import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import rx.Scheduler;
import rx.Subscription;
import rx.functions.Action0;
import rx.internal.schedulers.GenericScheduledExecutorService;
import rx.internal.schedulers.ScheduledAction;
import rx.plugins.RxJavaHooks;
import rx.subscriptions.CompositeSubscription;
import rx.subscriptions.MultipleAssignmentSubscription;
import rx.subscriptions.Subscriptions;

public final class ExecutorScheduler
extends Scheduler {
    final Executor executor;

    public ExecutorScheduler(Executor executor) {
        this.executor = executor;
    }

    @Override
    public Scheduler.Worker createWorker() {
        return new ExecutorSchedulerWorker(this.executor);
    }

    static final class ExecutorSchedulerWorker
    extends Scheduler.Worker
    implements Runnable {
        final Executor executor;
        final CompositeSubscription tasks;
        final ConcurrentLinkedQueue<ScheduledAction> queue;
        final AtomicInteger wip;
        final ScheduledExecutorService service;

        public ExecutorSchedulerWorker(Executor executor) {
            this.executor = executor;
            this.queue = new ConcurrentLinkedQueue();
            this.wip = new AtomicInteger();
            this.tasks = new CompositeSubscription();
            this.service = GenericScheduledExecutorService.getInstance();
        }

        @Override
        public Subscription schedule(Action0 action) {
            if (this.isUnsubscribed()) {
                return Subscriptions.unsubscribed();
            }
            action = RxJavaHooks.onScheduledAction(action);
            ScheduledAction ea = new ScheduledAction(action, this.tasks);
            this.tasks.add(ea);
            this.queue.offer(ea);
            if (this.wip.getAndIncrement() == 0) {
                try {
                    this.executor.execute(this);
                }
                catch (RejectedExecutionException t3) {
                    this.tasks.remove(ea);
                    this.wip.decrementAndGet();
                    RxJavaHooks.onError(t3);
                    throw t3;
                }
            }
            return ea;
        }

        @Override
        public void run() {
            do {
                if (this.tasks.isUnsubscribed()) {
                    this.queue.clear();
                    return;
                }
                ScheduledAction sa = this.queue.poll();
                if (sa == null) {
                    return;
                }
                if (sa.isUnsubscribed()) continue;
                if (!this.tasks.isUnsubscribed()) {
                    sa.run();
                    continue;
                }
                this.queue.clear();
                return;
            } while (this.wip.decrementAndGet() != 0);
        }

        @Override
        public Subscription schedule(Action0 action, long delayTime, TimeUnit unit) {
            if (delayTime <= 0L) {
                return this.schedule(action);
            }
            if (this.isUnsubscribed()) {
                return Subscriptions.unsubscribed();
            }
            final Action0 decorated = RxJavaHooks.onScheduledAction(action);
            MultipleAssignmentSubscription first2 = new MultipleAssignmentSubscription();
            final MultipleAssignmentSubscription mas = new MultipleAssignmentSubscription();
            mas.set(first2);
            this.tasks.add(mas);
            final Subscription removeMas = Subscriptions.create(new Action0(){

                @Override
                public void call() {
                    ExecutorSchedulerWorker.this.tasks.remove(mas);
                }
            });
            ScheduledAction ea = new ScheduledAction(new Action0(){

                @Override
                public void call() {
                    if (mas.isUnsubscribed()) {
                        return;
                    }
                    Subscription s2 = ExecutorSchedulerWorker.this.schedule(decorated);
                    mas.set(s2);
                    if (s2.getClass() == ScheduledAction.class) {
                        ((ScheduledAction)s2).add(removeMas);
                    }
                }
            });
            first2.set(ea);
            try {
                ScheduledFuture<?> f = this.service.schedule(ea, delayTime, unit);
                ea.add(f);
            }
            catch (RejectedExecutionException t3) {
                RxJavaHooks.onError(t3);
                throw t3;
            }
            return removeMas;
        }

        @Override
        public boolean isUnsubscribed() {
            return this.tasks.isUnsubscribed();
        }

        @Override
        public void unsubscribe() {
            this.tasks.unsubscribe();
            this.queue.clear();
        }
    }
}

