/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import rx.Scheduler;
import rx.Single;
import rx.SingleSubscriber;
import rx.functions.Action0;
import rx.plugins.RxJavaHooks;

public final class SingleTimeout<T>
implements Single.OnSubscribe<T> {
    final Single.OnSubscribe<T> source;
    final long timeout;
    final TimeUnit unit;
    final Scheduler scheduler;
    final Single.OnSubscribe<? extends T> other;

    public SingleTimeout(Single.OnSubscribe<T> source2, long timeout, TimeUnit unit, Scheduler scheduler, Single.OnSubscribe<? extends T> other) {
        this.source = source2;
        this.timeout = timeout;
        this.unit = unit;
        this.scheduler = scheduler;
        this.other = other;
    }

    @Override
    public void call(SingleSubscriber<? super T> t3) {
        TimeoutSingleSubscriber<T> parent = new TimeoutSingleSubscriber<T>(t3, this.other);
        Scheduler.Worker w = this.scheduler.createWorker();
        parent.add(w);
        t3.add(parent);
        w.schedule(parent, this.timeout, this.unit);
        this.source.call(parent);
    }

    static final class TimeoutSingleSubscriber<T>
    extends SingleSubscriber<T>
    implements Action0 {
        final SingleSubscriber<? super T> actual;
        final AtomicBoolean once;
        final Single.OnSubscribe<? extends T> other;

        TimeoutSingleSubscriber(SingleSubscriber<? super T> actual, Single.OnSubscribe<? extends T> other) {
            this.actual = actual;
            this.other = other;
            this.once = new AtomicBoolean();
        }

        @Override
        public void onSuccess(T value) {
            if (this.once.compareAndSet(false, true)) {
                try {
                    this.actual.onSuccess(value);
                }
                finally {
                    this.unsubscribe();
                }
            }
        }

        @Override
        public void onError(Throwable error2) {
            if (this.once.compareAndSet(false, true)) {
                try {
                    this.actual.onError(error2);
                }
                finally {
                    this.unsubscribe();
                }
            } else {
                RxJavaHooks.onError(error2);
            }
        }

        @Override
        public void call() {
            if (this.once.compareAndSet(false, true)) {
                try {
                    Single.OnSubscribe<OtherSubscriber<? super T>> o = this.other;
                    if (o == null) {
                        this.actual.onError(new TimeoutException());
                    } else {
                        OtherSubscriber<? super T> p = new OtherSubscriber<T>(this.actual);
                        this.actual.add(p);
                        o.call(p);
                    }
                }
                finally {
                    this.unsubscribe();
                }
            }
        }

        static final class OtherSubscriber<T>
        extends SingleSubscriber<T> {
            final SingleSubscriber<? super T> actual;

            OtherSubscriber(SingleSubscriber<? super T> actual) {
                this.actual = actual;
            }

            @Override
            public void onSuccess(T value) {
                this.actual.onSuccess(value);
            }

            @Override
            public void onError(Throwable error2) {
                this.actual.onError(error2);
            }
        }
    }
}

