/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicBoolean;
import rx.Observable;
import rx.Single;
import rx.SingleSubscriber;
import rx.Subscriber;
import rx.plugins.RxJavaHooks;

public final class SingleTakeUntilObservable<T, U>
implements Single.OnSubscribe<T> {
    final Single.OnSubscribe<T> source;
    final Observable<? extends U> other;

    public SingleTakeUntilObservable(Single.OnSubscribe<T> source2, Observable<? extends U> other) {
        this.source = source2;
        this.other = other;
    }

    @Override
    public void call(SingleSubscriber<? super T> t3) {
        TakeUntilSourceSubscriber parent = new TakeUntilSourceSubscriber(t3);
        t3.add(parent);
        this.other.subscribe(parent.other);
        this.source.call(parent);
    }

    static final class TakeUntilSourceSubscriber<T, U>
    extends SingleSubscriber<T> {
        final SingleSubscriber<? super T> actual;
        final AtomicBoolean once;
        final Subscriber<U> other;

        TakeUntilSourceSubscriber(SingleSubscriber<? super T> actual) {
            this.actual = actual;
            this.once = new AtomicBoolean();
            this.other = new OtherSubscriber();
            this.add(this.other);
        }

        @Override
        public void onSuccess(T value) {
            if (this.once.compareAndSet(false, true)) {
                this.unsubscribe();
                this.actual.onSuccess(value);
            }
        }

        @Override
        public void onError(Throwable error2) {
            if (this.once.compareAndSet(false, true)) {
                this.unsubscribe();
                this.actual.onError(error2);
            } else {
                RxJavaHooks.onError(error2);
            }
        }

        final class OtherSubscriber
        extends Subscriber<U> {
            OtherSubscriber() {
            }

            @Override
            public void onNext(U value) {
                this.onCompleted();
            }

            @Override
            public void onError(Throwable error2) {
                TakeUntilSourceSubscriber.this.onError(error2);
            }

            @Override
            public void onCompleted() {
                this.onError(new CancellationException("Single::takeUntil(Observable) - Stream was canceled before emitting a terminal event."));
            }
        }
    }
}

