/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicBoolean;
import rx.Completable;
import rx.CompletableSubscriber;
import rx.Single;
import rx.SingleSubscriber;
import rx.Subscription;
import rx.plugins.RxJavaHooks;

public final class SingleTakeUntilCompletable<T>
implements Single.OnSubscribe<T> {
    final Single.OnSubscribe<T> source;
    final Completable other;

    public SingleTakeUntilCompletable(Single.OnSubscribe<T> source2, Completable other) {
        this.source = source2;
        this.other = other;
    }

    @Override
    public void call(SingleSubscriber<? super T> t3) {
        TakeUntilSourceSubscriber<? super T> parent = new TakeUntilSourceSubscriber<T>(t3);
        t3.add(parent);
        this.other.subscribe(parent);
        this.source.call(parent);
    }

    static final class TakeUntilSourceSubscriber<T>
    extends SingleSubscriber<T>
    implements CompletableSubscriber {
        final SingleSubscriber<? super T> actual;
        final AtomicBoolean once;

        TakeUntilSourceSubscriber(SingleSubscriber<? super T> actual) {
            this.actual = actual;
            this.once = new AtomicBoolean();
        }

        @Override
        public void onSubscribe(Subscription d) {
            this.add(d);
        }

        @Override
        public void onSuccess(T value) {
            if (this.once.compareAndSet(false, true)) {
                this.unsubscribe();
                this.actual.onSuccess(value);
            }
        }

        @Override
        public void onError(Throwable error2) {
            if (this.once.compareAndSet(false, true)) {
                this.unsubscribe();
                this.actual.onError(error2);
            } else {
                RxJavaHooks.onError(error2);
            }
        }

        @Override
        public void onCompleted() {
            this.onError(new CancellationException("Single::takeUntil(Completable) - Stream was canceled before emitting a terminal event."));
        }
    }
}

