/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.Arrays;
import rx.Single;
import rx.SingleSubscriber;
import rx.exceptions.CompositeException;
import rx.exceptions.Exceptions;
import rx.functions.Action1;
import rx.functions.Func0;
import rx.functions.Func1;
import rx.plugins.RxJavaHooks;

public final class SingleOnSubscribeUsing<T, Resource>
implements Single.OnSubscribe<T> {
    final Func0<Resource> resourceFactory;
    final Func1<? super Resource, ? extends Single<? extends T>> singleFactory;
    final Action1<? super Resource> disposeAction;
    final boolean disposeEagerly;

    public SingleOnSubscribeUsing(Func0<Resource> resourceFactory, Func1<? super Resource, ? extends Single<? extends T>> observableFactory, Action1<? super Resource> disposeAction, boolean disposeEagerly) {
        this.resourceFactory = resourceFactory;
        this.singleFactory = observableFactory;
        this.disposeAction = disposeAction;
        this.disposeEagerly = disposeEagerly;
    }

    @Override
    public void call(final SingleSubscriber<? super T> child) {
        Single<T> single2;
        Resource resource2;
        try {
            resource2 = this.resourceFactory.call();
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal(ex);
            child.onError(ex);
            return;
        }
        try {
            single2 = this.singleFactory.call(resource2);
        }
        catch (Throwable ex) {
            this.handleSubscriptionTimeError(child, resource2, ex);
            return;
        }
        if (single2 == null) {
            this.handleSubscriptionTimeError(child, resource2, new NullPointerException("The single"));
            return;
        }
        SingleSubscriber parent = new SingleSubscriber<T>(){

            @Override
            public void onSuccess(T value) {
                if (SingleOnSubscribeUsing.this.disposeEagerly) {
                    try {
                        SingleOnSubscribeUsing.this.disposeAction.call(resource2);
                    }
                    catch (Throwable ex) {
                        Exceptions.throwIfFatal(ex);
                        child.onError(ex);
                        return;
                    }
                }
                child.onSuccess(value);
                if (!SingleOnSubscribeUsing.this.disposeEagerly) {
                    try {
                        SingleOnSubscribeUsing.this.disposeAction.call(resource2);
                    }
                    catch (Throwable ex2) {
                        Exceptions.throwIfFatal(ex2);
                        RxJavaHooks.onError(ex2);
                    }
                }
            }

            @Override
            public void onError(Throwable error2) {
                SingleOnSubscribeUsing.this.handleSubscriptionTimeError(child, resource2, error2);
            }
        };
        child.add(parent);
        single2.subscribe(parent);
    }

    void handleSubscriptionTimeError(SingleSubscriber<? super T> t3, Resource resource2, Throwable ex) {
        Exceptions.throwIfFatal(ex);
        if (this.disposeEagerly) {
            try {
                this.disposeAction.call(resource2);
            }
            catch (Throwable ex2) {
                Exceptions.throwIfFatal(ex2);
                ex = new CompositeException(Arrays.asList(ex, ex2));
            }
        }
        t3.onError(ex);
        if (!this.disposeEagerly) {
            try {
                this.disposeAction.call(resource2);
            }
            catch (Throwable ex2) {
                Exceptions.throwIfFatal(ex2);
                RxJavaHooks.onError(ex2);
            }
        }
    }
}

