/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import rx.Single;
import rx.SingleSubscriber;
import rx.exceptions.Exceptions;
import rx.exceptions.OnErrorThrowable;
import rx.functions.Func1;
import rx.plugins.RxJavaHooks;

public final class SingleOnSubscribeMap<T, R>
implements Single.OnSubscribe<R> {
    final Single<T> source;
    final Func1<? super T, ? extends R> transformer;

    public SingleOnSubscribeMap(Single<T> source2, Func1<? super T, ? extends R> transformer) {
        this.source = source2;
        this.transformer = transformer;
    }

    @Override
    public void call(SingleSubscriber<? super R> o) {
        MapSubscriber<? super T, ? extends R> parent = new MapSubscriber<T, R>(o, this.transformer);
        o.add(parent);
        this.source.subscribe(parent);
    }

    static final class MapSubscriber<T, R>
    extends SingleSubscriber<T> {
        final SingleSubscriber<? super R> actual;
        final Func1<? super T, ? extends R> mapper;
        boolean done;

        public MapSubscriber(SingleSubscriber<? super R> actual, Func1<? super T, ? extends R> mapper2) {
            this.actual = actual;
            this.mapper = mapper2;
        }

        @Override
        public void onSuccess(T t3) {
            R result2;
            try {
                result2 = this.mapper.call(t3);
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                this.unsubscribe();
                this.onError(OnErrorThrowable.addValueAsLastCause(ex, t3));
                return;
            }
            this.actual.onSuccess(result2);
        }

        @Override
        public void onError(Throwable e2) {
            if (this.done) {
                RxJavaHooks.onError(e2);
                return;
            }
            this.done = true;
            this.actual.onError(e2);
        }
    }
}

