/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import rx.Single;
import rx.SingleSubscriber;
import rx.exceptions.Exceptions;
import rx.functions.Func1;

public final class SingleOnErrorReturn<T>
implements Single.OnSubscribe<T> {
    final Single.OnSubscribe<T> source;
    final Func1<Throwable, ? extends T> resumeFunction;

    public SingleOnErrorReturn(Single.OnSubscribe<T> source2, Func1<Throwable, ? extends T> resumeFunction) {
        this.source = source2;
        this.resumeFunction = resumeFunction;
    }

    @Override
    public void call(SingleSubscriber<? super T> t3) {
        OnErrorReturnsSingleSubscriber<? extends T> parent = new OnErrorReturnsSingleSubscriber<T>(t3, this.resumeFunction);
        t3.add(parent);
        this.source.call(parent);
    }

    static final class OnErrorReturnsSingleSubscriber<T>
    extends SingleSubscriber<T> {
        final SingleSubscriber<? super T> actual;
        final Func1<Throwable, ? extends T> resumeFunction;

        public OnErrorReturnsSingleSubscriber(SingleSubscriber<? super T> actual, Func1<Throwable, ? extends T> resumeFunction) {
            this.actual = actual;
            this.resumeFunction = resumeFunction;
        }

        @Override
        public void onSuccess(T value) {
            this.actual.onSuccess(value);
        }

        @Override
        public void onError(Throwable error2) {
            T v;
            try {
                v = this.resumeFunction.call(error2);
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                this.actual.onError(ex);
                return;
            }
            this.actual.onSuccess(v);
        }
    }
}

