/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import rx.Scheduler;
import rx.Single;
import rx.SingleSubscriber;
import rx.functions.Action0;

public final class SingleObserveOn<T>
implements Single.OnSubscribe<T> {
    final Single.OnSubscribe<T> source;
    final Scheduler scheduler;

    public SingleObserveOn(Single.OnSubscribe<T> source2, Scheduler scheduler) {
        this.source = source2;
        this.scheduler = scheduler;
    }

    @Override
    public void call(SingleSubscriber<? super T> t3) {
        Scheduler.Worker w = this.scheduler.createWorker();
        ObserveOnSingleSubscriber<? super T> parent = new ObserveOnSingleSubscriber<T>(t3, w);
        t3.add(w);
        t3.add(parent);
        this.source.call(parent);
    }

    static final class ObserveOnSingleSubscriber<T>
    extends SingleSubscriber<T>
    implements Action0 {
        final SingleSubscriber<? super T> actual;
        final Scheduler.Worker w;
        T value;
        Throwable error;

        public ObserveOnSingleSubscriber(SingleSubscriber<? super T> actual, Scheduler.Worker w) {
            this.actual = actual;
            this.w = w;
        }

        @Override
        public void onSuccess(T value) {
            this.value = value;
            this.w.schedule(this);
        }

        @Override
        public void onError(Throwable error2) {
            this.error = error2;
            this.w.schedule(this);
        }

        @Override
        public void call() {
            try {
                Throwable ex = this.error;
                if (ex != null) {
                    this.error = null;
                    this.actual.onError(ex);
                } else {
                    T v = this.value;
                    this.value = null;
                    this.actual.onSuccess(v);
                }
            }
            finally {
                this.w.unsubscribe();
            }
        }
    }
}

