/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import rx.Observable;
import rx.Subscriber;
import rx.exceptions.Exceptions;
import rx.functions.Func2;
import rx.internal.producers.SingleDelayedProducer;

public final class OperatorToObservableSortedList<T>
implements Observable.Operator<List<T>, T> {
    final Comparator<? super T> sortFunction;
    final int initialCapacity;
    private static final Comparator DEFAULT_SORT_FUNCTION = new DefaultComparableFunction();

    public OperatorToObservableSortedList(int initialCapacity) {
        this.sortFunction = DEFAULT_SORT_FUNCTION;
        this.initialCapacity = initialCapacity;
    }

    public OperatorToObservableSortedList(final Func2<? super T, ? super T, Integer> sortFunction, int initialCapacity) {
        this.initialCapacity = initialCapacity;
        this.sortFunction = new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                return (Integer)sortFunction.call(o1, o2);
            }
        };
    }

    @Override
    public Subscriber<? super T> call(final Subscriber<? super List<T>> child) {
        final SingleDelayedProducer<? super List<T>> producer = new SingleDelayedProducer<List<T>>(child);
        Subscriber result2 = new Subscriber<T>(){
            List<T> list;
            boolean completed;
            {
                this.list = new ArrayList(OperatorToObservableSortedList.this.initialCapacity);
            }

            @Override
            public void onStart() {
                this.request(Long.MAX_VALUE);
            }

            @Override
            public void onCompleted() {
                if (!this.completed) {
                    this.completed = true;
                    List a = this.list;
                    this.list = null;
                    try {
                        Collections.sort(a, OperatorToObservableSortedList.this.sortFunction);
                    }
                    catch (Throwable e2) {
                        Exceptions.throwOrReport(e2, this);
                        return;
                    }
                    producer.setValue(a);
                }
            }

            @Override
            public void onError(Throwable e2) {
                child.onError(e2);
            }

            @Override
            public void onNext(T value) {
                if (!this.completed) {
                    this.list.add(value);
                }
            }
        };
        child.add(result2);
        child.setProducer(producer);
        return result2;
    }

    static final class DefaultComparableFunction
    implements Comparator<Object> {
        DefaultComparableFunction() {
        }

        @Override
        public int compare(Object t12, Object t22) {
            Comparable c1 = (Comparable)t12;
            Comparable c2 = (Comparable)t22;
            return c1.compareTo(c2);
        }
    }
}

