/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import rx.Observable;
import rx.Producer;
import rx.Subscriber;
import rx.exceptions.Exceptions;
import rx.functions.Func1;

public final class OperatorTakeUntilPredicate<T>
implements Observable.Operator<T, T> {
    final Func1<? super T, Boolean> stopPredicate;

    public OperatorTakeUntilPredicate(Func1<? super T, Boolean> stopPredicate) {
        this.stopPredicate = stopPredicate;
    }

    @Override
    public Subscriber<? super T> call(Subscriber<? super T> child) {
        final ParentSubscriber parent = new ParentSubscriber(child);
        child.add(parent);
        child.setProducer(new Producer(){

            @Override
            public void request(long n) {
                parent.downstreamRequest(n);
            }
        });
        return parent;
    }

    final class ParentSubscriber
    extends Subscriber<T> {
        private final Subscriber<? super T> child;
        private boolean done;

        ParentSubscriber(Subscriber<? super T> child) {
            this.child = child;
        }

        @Override
        public void onNext(T t3) {
            boolean stop2;
            this.child.onNext(t3);
            try {
                stop2 = OperatorTakeUntilPredicate.this.stopPredicate.call(t3);
            }
            catch (Throwable e2) {
                this.done = true;
                Exceptions.throwOrReport(e2, this.child, t3);
                this.unsubscribe();
                return;
            }
            if (stop2) {
                this.done = true;
                this.child.onCompleted();
                this.unsubscribe();
            }
        }

        @Override
        public void onCompleted() {
            if (!this.done) {
                this.child.onCompleted();
            }
        }

        @Override
        public void onError(Throwable e2) {
            if (!this.done) {
                this.child.onError(e2);
            }
        }

        void downstreamRequest(long n) {
            this.request(n);
        }
    }
}

