/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.concurrent.TimeUnit;
import rx.Observable;
import rx.Scheduler;
import rx.Subscriber;
import rx.functions.Action0;
import rx.observers.SerializedSubscriber;

public final class OperatorTakeTimed<T>
implements Observable.Operator<T, T> {
    final long time;
    final TimeUnit unit;
    final Scheduler scheduler;

    public OperatorTakeTimed(long time2, TimeUnit unit, Scheduler scheduler) {
        this.time = time2;
        this.unit = unit;
        this.scheduler = scheduler;
    }

    @Override
    public Subscriber<? super T> call(Subscriber<? super T> child) {
        Scheduler.Worker worker = this.scheduler.createWorker();
        child.add(worker);
        TakeSubscriber<? super T> ts = new TakeSubscriber<T>(new SerializedSubscriber<T>(child));
        worker.schedule(ts, this.time, this.unit);
        return ts;
    }

    static final class TakeSubscriber<T>
    extends Subscriber<T>
    implements Action0 {
        final Subscriber<? super T> child;

        public TakeSubscriber(Subscriber<? super T> child) {
            super(child);
            this.child = child;
        }

        @Override
        public void onNext(T t3) {
            this.child.onNext(t3);
        }

        @Override
        public void onError(Throwable e2) {
            this.child.onError(e2);
            this.unsubscribe();
        }

        @Override
        public void onCompleted() {
            this.child.onCompleted();
            this.unsubscribe();
        }

        @Override
        public void call() {
            this.onCompleted();
        }
    }
}

