/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import rx.Observable;
import rx.Subscriber;
import rx.exceptions.Exceptions;
import rx.functions.Func1;
import rx.functions.Func2;

public final class OperatorSkipWhile<T>
implements Observable.Operator<T, T> {
    final Func2<? super T, Integer, Boolean> predicate;

    public OperatorSkipWhile(Func2<? super T, Integer, Boolean> predicate) {
        this.predicate = predicate;
    }

    @Override
    public Subscriber<? super T> call(final Subscriber<? super T> child) {
        return new Subscriber<T>(child){
            boolean skipping;
            int index;
            {
                super(subscriber);
                this.skipping = true;
            }

            @Override
            public void onNext(T t3) {
                if (!this.skipping) {
                    child.onNext(t3);
                } else {
                    boolean skip;
                    try {
                        skip = OperatorSkipWhile.this.predicate.call(t3, this.index++);
                    }
                    catch (Throwable e2) {
                        Exceptions.throwOrReport(e2, child, t3);
                        return;
                    }
                    if (!skip) {
                        this.skipping = false;
                        child.onNext(t3);
                    } else {
                        this.request(1L);
                    }
                }
            }

            @Override
            public void onError(Throwable e2) {
                child.onError(e2);
            }

            @Override
            public void onCompleted() {
                child.onCompleted();
            }
        };
    }

    public static <T> Func2<T, Integer, Boolean> toPredicate2(final Func1<? super T, Boolean> predicate) {
        return new Func2<T, Integer, Boolean>(){

            @Override
            public Boolean call(T t12, Integer t22) {
                return (Boolean)predicate.call(t12);
            }
        };
    }
}

