/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.concurrent.TimeUnit;
import rx.Observable;
import rx.Scheduler;
import rx.Subscriber;
import rx.schedulers.Timestamped;

public class OperatorSkipLastTimed<T>
implements Observable.Operator<T, T> {
    final long timeInMillis;
    final Scheduler scheduler;

    public OperatorSkipLastTimed(long time2, TimeUnit unit, Scheduler scheduler) {
        this.timeInMillis = unit.toMillis(time2);
        this.scheduler = scheduler;
    }

    @Override
    public Subscriber<? super T> call(final Subscriber<? super T> subscriber) {
        return new Subscriber<T>(subscriber){
            private Deque<Timestamped<T>> buffer;
            {
                super(subscriber3);
                this.buffer = new ArrayDeque();
            }

            private void emitItemsOutOfWindow(long now2) {
                Timestamped v;
                long limit = now2 - OperatorSkipLastTimed.this.timeInMillis;
                while (!this.buffer.isEmpty() && (v = this.buffer.getFirst()).getTimestampMillis() < limit) {
                    this.buffer.removeFirst();
                    subscriber.onNext(v.getValue());
                }
            }

            @Override
            public void onNext(T value) {
                long now2 = OperatorSkipLastTimed.this.scheduler.now();
                this.emitItemsOutOfWindow(now2);
                this.buffer.offerLast(new Timestamped(now2, value));
            }

            @Override
            public void onError(Throwable e2) {
                subscriber.onError(e2);
            }

            @Override
            public void onCompleted() {
                this.emitItemsOutOfWindow(OperatorSkipLastTimed.this.scheduler.now());
                subscriber.onCompleted();
            }
        };
    }
}

