/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import rx.Observable;
import rx.Producer;
import rx.Subscriber;

public final class OperatorSkip<T>
implements Observable.Operator<T, T> {
    final int toSkip;

    public OperatorSkip(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("n >= 0 required but it was " + n);
        }
        this.toSkip = n;
    }

    @Override
    public Subscriber<? super T> call(final Subscriber<? super T> child) {
        return new Subscriber<T>(child){
            int skipped;

            @Override
            public void onCompleted() {
                child.onCompleted();
            }

            @Override
            public void onError(Throwable e2) {
                child.onError(e2);
            }

            @Override
            public void onNext(T t3) {
                if (this.skipped >= OperatorSkip.this.toSkip) {
                    child.onNext(t3);
                } else {
                    ++this.skipped;
                }
            }

            @Override
            public void setProducer(Producer producer) {
                child.setProducer(producer);
                producer.request(OperatorSkip.this.toSkip);
            }
        };
    }
}

