/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.Queue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import rx.Observable;
import rx.Producer;
import rx.Subscriber;
import rx.Subscription;
import rx.exceptions.MissingBackpressureException;
import rx.functions.Action0;
import rx.functions.Action1;
import rx.functions.Func1;
import rx.internal.operators.NotificationLite;
import rx.internal.operators.OnSubscribePublishMulticast;
import rx.internal.util.RxRingBuffer;
import rx.internal.util.atomic.SpscAtomicArrayQueue;
import rx.internal.util.unsafe.SpscArrayQueue;
import rx.internal.util.unsafe.UnsafeAccess;
import rx.observables.ConnectableObservable;
import rx.subscriptions.Subscriptions;

public final class OperatorPublish<T>
extends ConnectableObservable<T> {
    final Observable<? extends T> source;
    final AtomicReference<PublishSubscriber<T>> current;

    public static <T> ConnectableObservable<T> create(Observable<? extends T> source2) {
        final AtomicReference<PublishSubscriber<T>> curr = new AtomicReference<PublishSubscriber<T>>();
        Observable.OnSubscribe onSubscribe = new Observable.OnSubscribe<T>(){

            @Override
            public void call(Subscriber<? super T> child) {
                InnerProducer inner;
                while (true) {
                    PublishSubscriber r;
                    if ((r = (PublishSubscriber)curr.get()) == null || r.isUnsubscribed()) {
                        PublishSubscriber u = new PublishSubscriber(curr);
                        u.init();
                        if (!curr.compareAndSet(r, u)) continue;
                        r = u;
                    }
                    if (r.add(inner = new InnerProducer(r, child))) break;
                }
                child.add(inner);
                child.setProducer(inner);
            }
        };
        return new OperatorPublish<T>(onSubscribe, source2, curr);
    }

    public static <T, R> Observable<R> create(Observable<? extends T> source2, Func1<? super Observable<T>, ? extends Observable<R>> selector) {
        return OperatorPublish.create(source2, selector, false);
    }

    public static <T, R> Observable<R> create(final Observable<? extends T> source2, final Func1<? super Observable<T>, ? extends Observable<R>> selector, final boolean delayError) {
        return OperatorPublish.unsafeCreate(new Observable.OnSubscribe<R>(){

            @Override
            public void call(final Subscriber<? super R> child) {
                final OnSubscribePublishMulticast op = new OnSubscribePublishMulticast(RxRingBuffer.SIZE, delayError);
                Subscriber subscriber = new Subscriber<R>(){

                    @Override
                    public void onNext(R t3) {
                        child.onNext(t3);
                    }

                    @Override
                    public void onError(Throwable e2) {
                        op.unsubscribe();
                        child.onError(e2);
                    }

                    @Override
                    public void onCompleted() {
                        op.unsubscribe();
                        child.onCompleted();
                    }

                    @Override
                    public void setProducer(Producer p) {
                        child.setProducer(p);
                    }
                };
                child.add(op);
                child.add(subscriber);
                ((Observable)selector.call(Observable.unsafeCreate(op))).unsafeSubscribe(subscriber);
                source2.unsafeSubscribe(op.subscriber());
            }
        });
    }

    private OperatorPublish(Observable.OnSubscribe<T> onSubscribe, Observable<? extends T> source2, AtomicReference<PublishSubscriber<T>> current) {
        super(onSubscribe);
        this.source = source2;
        this.current = current;
    }

    @Override
    public void connect(Action1<? super Subscription> connection) {
        PublishSubscriber<T> ps;
        while ((ps = this.current.get()) == null || ps.isUnsubscribed()) {
            PublishSubscriber<T> u = new PublishSubscriber<T>(this.current);
            u.init();
            if (!this.current.compareAndSet(ps, u)) continue;
            ps = u;
            break;
        }
        boolean doConnect = !ps.shouldConnect.get() && ps.shouldConnect.compareAndSet(false, true);
        connection.call(ps);
        if (doConnect) {
            this.source.unsafeSubscribe(ps);
        }
    }

    static final class InnerProducer<T>
    extends AtomicLong
    implements Producer,
    Subscription {
        private static final long serialVersionUID = -4453897557930727610L;
        final PublishSubscriber<T> parent;
        final Subscriber<? super T> child;
        static final long UNSUBSCRIBED = Long.MIN_VALUE;
        static final long NOT_REQUESTED = -4611686018427387904L;

        public InnerProducer(PublishSubscriber<T> parent, Subscriber<? super T> child) {
            this.parent = parent;
            this.child = child;
            this.lazySet(-4611686018427387904L);
        }

        @Override
        public void request(long n) {
            long u;
            long r;
            if (n < 0L) {
                return;
            }
            do {
                if ((r = this.get()) == Long.MIN_VALUE) {
                    return;
                }
                if (r >= 0L && n == 0L) {
                    return;
                }
                if (r == -4611686018427387904L) {
                    u = n;
                    continue;
                }
                u = r + n;
                if (u >= 0L) continue;
                u = Long.MAX_VALUE;
            } while (!this.compareAndSet(r, u));
            this.parent.dispatch();
        }

        public long produced(long n) {
            long u;
            long r;
            if (n <= 0L) {
                throw new IllegalArgumentException("Cant produce zero or less");
            }
            do {
                if ((r = this.get()) == -4611686018427387904L) {
                    throw new IllegalStateException("Produced without request");
                }
                if (r == Long.MIN_VALUE) {
                    return Long.MIN_VALUE;
                }
                u = r - n;
                if (u >= 0L) continue;
                throw new IllegalStateException("More produced (" + n + ") than requested (" + r + ")");
            } while (!this.compareAndSet(r, u));
            return u;
        }

        @Override
        public boolean isUnsubscribed() {
            return this.get() == Long.MIN_VALUE;
        }

        @Override
        public void unsubscribe() {
            long r = this.get();
            if (r != Long.MIN_VALUE && (r = this.getAndSet(Long.MIN_VALUE)) != Long.MIN_VALUE) {
                this.parent.remove(this);
                this.parent.dispatch();
            }
        }
    }

    static final class PublishSubscriber<T>
    extends Subscriber<T>
    implements Subscription {
        final Queue<Object> queue = UnsafeAccess.isUnsafeAvailable() ? new SpscArrayQueue(RxRingBuffer.SIZE) : new SpscAtomicArrayQueue(RxRingBuffer.SIZE);
        final AtomicReference<PublishSubscriber<T>> current;
        volatile Object terminalEvent;
        static final InnerProducer[] EMPTY = new InnerProducer[0];
        static final InnerProducer[] TERMINATED = new InnerProducer[0];
        final AtomicReference<InnerProducer[]> producers = new AtomicReference<InnerProducer[]>(EMPTY);
        final AtomicBoolean shouldConnect;
        boolean emitting;
        boolean missed;

        public PublishSubscriber(AtomicReference<PublishSubscriber<T>> current) {
            this.current = current;
            this.shouldConnect = new AtomicBoolean();
        }

        void init() {
            this.add(Subscriptions.create(new Action0(){

                @Override
                public void call() {
                    PublishSubscriber.this.producers.getAndSet(TERMINATED);
                    PublishSubscriber.this.current.compareAndSet(PublishSubscriber.this, null);
                }
            }));
        }

        @Override
        public void onStart() {
            this.request(RxRingBuffer.SIZE);
        }

        @Override
        public void onNext(T t3) {
            if (!this.queue.offer(NotificationLite.next(t3))) {
                this.onError(new MissingBackpressureException());
            } else {
                this.dispatch();
            }
        }

        @Override
        public void onError(Throwable e2) {
            if (this.terminalEvent == null) {
                this.terminalEvent = NotificationLite.error(e2);
                this.dispatch();
            }
        }

        @Override
        public void onCompleted() {
            if (this.terminalEvent == null) {
                this.terminalEvent = NotificationLite.completed();
                this.dispatch();
            }
        }

        boolean add(InnerProducer<T> producer) {
            InnerProducer[] u;
            InnerProducer[] c;
            if (producer == null) {
                throw new NullPointerException();
            }
            do {
                if ((c = this.producers.get()) == TERMINATED) {
                    return false;
                }
                int len = c.length;
                u = new InnerProducer[len + 1];
                System.arraycopy(c, 0, u, 0, len);
                u[len] = producer;
            } while (!this.producers.compareAndSet(c, u));
            return true;
        }

        void remove(InnerProducer<T> producer) {
            InnerProducer[] u;
            InnerProducer[] c;
            do {
                if ((c = this.producers.get()) == EMPTY || c == TERMINATED) {
                    return;
                }
                int j = -1;
                int len = c.length;
                for (int i = 0; i < len; ++i) {
                    if (!c[i].equals(producer)) continue;
                    j = i;
                    break;
                }
                if (j < 0) {
                    return;
                }
                if (len == 1) {
                    u = EMPTY;
                    continue;
                }
                u = new InnerProducer[len - 1];
                System.arraycopy(c, 0, u, 0, j);
                System.arraycopy(c, j + 1, u, j, len - j - 1);
            } while (!this.producers.compareAndSet(c, u));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean checkTerminated(Object term, boolean empty2) {
            if (term != null) {
                if (NotificationLite.isCompleted(term)) {
                    if (empty2) {
                        this.current.compareAndSet(this, null);
                        try {
                            for (InnerProducer ip : this.producers.getAndSet(TERMINATED)) {
                                ip.child.onCompleted();
                            }
                        }
                        finally {
                            this.unsubscribe();
                        }
                        return true;
                    }
                } else {
                    Throwable t3 = NotificationLite.getError(term);
                    this.current.compareAndSet(this, null);
                    try {
                        for (InnerProducer ip : this.producers.getAndSet(TERMINATED)) {
                            ip.child.onError(t3);
                        }
                    }
                    finally {
                        this.unsubscribe();
                    }
                    return true;
                }
            }
            return false;
        }

        /*
         * Exception decompiling
         */
        void dispatch() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [31[UNCONDITIONALDOLOOP]], but top level block is 16[MONITOR]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }
}

