/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import rx.Observable;
import rx.Producer;
import rx.Subscriber;
import rx.exceptions.Exceptions;
import rx.functions.Func0;
import rx.functions.Func1;
import rx.internal.operators.BackpressureUtils;

public final class OperatorMapNotification<T, R>
implements Observable.Operator<R, T> {
    final Func1<? super T, ? extends R> onNext;
    final Func1<? super Throwable, ? extends R> onError;
    final Func0<? extends R> onCompleted;

    public OperatorMapNotification(Func1<? super T, ? extends R> onNext, Func1<? super Throwable, ? extends R> onError, Func0<? extends R> onCompleted) {
        this.onNext = onNext;
        this.onError = onError;
        this.onCompleted = onCompleted;
    }

    @Override
    public Subscriber<? super T> call(Subscriber<? super R> child) {
        final MapNotificationSubscriber<? super T, ? extends R> parent = new MapNotificationSubscriber<T, R>(child, this.onNext, this.onError, this.onCompleted);
        child.add(parent);
        child.setProducer(new Producer(){

            @Override
            public void request(long n) {
                parent.requestInner(n);
            }
        });
        return parent;
    }

    static final class MapNotificationSubscriber<T, R>
    extends Subscriber<T> {
        final Subscriber<? super R> actual;
        final Func1<? super T, ? extends R> onNext;
        final Func1<? super Throwable, ? extends R> onError;
        final Func0<? extends R> onCompleted;
        final AtomicLong requested;
        final AtomicLong missedRequested;
        final AtomicReference<Producer> producer;
        long produced;
        R value;
        static final long COMPLETED_FLAG = Long.MIN_VALUE;
        static final long REQUESTED_MASK = Long.MAX_VALUE;

        public MapNotificationSubscriber(Subscriber<? super R> actual, Func1<? super T, ? extends R> onNext, Func1<? super Throwable, ? extends R> onError, Func0<? extends R> onCompleted) {
            this.actual = actual;
            this.onNext = onNext;
            this.onError = onError;
            this.onCompleted = onCompleted;
            this.requested = new AtomicLong();
            this.missedRequested = new AtomicLong();
            this.producer = new AtomicReference();
        }

        @Override
        public void onNext(T t3) {
            try {
                ++this.produced;
                this.actual.onNext(this.onNext.call(t3));
            }
            catch (Throwable ex) {
                Exceptions.throwOrReport(ex, this.actual, t3);
            }
        }

        @Override
        public void onError(Throwable e2) {
            this.accountProduced();
            try {
                this.value = this.onError.call(e2);
            }
            catch (Throwable ex) {
                Exceptions.throwOrReport(ex, this.actual, (Object)e2);
            }
            this.tryEmit();
        }

        @Override
        public void onCompleted() {
            this.accountProduced();
            try {
                this.value = this.onCompleted.call();
            }
            catch (Throwable ex) {
                Exceptions.throwOrReport(ex, this.actual);
            }
            this.tryEmit();
        }

        void accountProduced() {
            long p = this.produced;
            if (p != 0L && this.producer.get() != null) {
                BackpressureUtils.produced(this.requested, p);
            }
        }

        @Override
        public void setProducer(Producer p) {
            if (this.producer.compareAndSet(null, p)) {
                long r = this.missedRequested.getAndSet(0L);
                if (r != 0L) {
                    p.request(r);
                }
            } else {
                throw new IllegalStateException("Producer already set!");
            }
        }

        void tryEmit() {
            long r;
            while (((r = this.requested.get()) & Long.MIN_VALUE) == 0L) {
                if (!this.requested.compareAndSet(r, r | Long.MIN_VALUE)) continue;
                if (r != 0L || this.producer.get() == null) {
                    if (!this.actual.isUnsubscribed()) {
                        this.actual.onNext(this.value);
                    }
                    if (!this.actual.isUnsubscribed()) {
                        this.actual.onCompleted();
                    }
                }
                return;
            }
        }

        void requestInner(long n) {
            if (n < 0L) {
                throw new IllegalArgumentException("n >= 0 required but it was " + n);
            }
            if (n == 0L) {
                return;
            }
            while (true) {
                long r;
                if (((r = this.requested.get()) & Long.MIN_VALUE) != 0L) {
                    long v = r & Long.MAX_VALUE;
                    long u = BackpressureUtils.addCap(v, n) | Long.MIN_VALUE;
                    if (!this.requested.compareAndSet(r, u)) continue;
                    if (v == 0L) {
                        if (!this.actual.isUnsubscribed()) {
                            this.actual.onNext(this.value);
                        }
                        if (!this.actual.isUnsubscribed()) {
                            this.actual.onCompleted();
                        }
                    }
                    return;
                }
                long u = BackpressureUtils.addCap(r, n);
                if (this.requested.compareAndSet(r, u)) break;
            }
            AtomicReference<Producer> localProducer = this.producer;
            Producer actualProducer = localProducer.get();
            if (actualProducer != null) {
                actualProducer.request(n);
            } else {
                long r;
                BackpressureUtils.getAndAddRequest(this.missedRequested, n);
                actualProducer = localProducer.get();
                if (actualProducer != null && (r = this.missedRequested.getAndSet(0L)) != 0L) {
                    actualProducer.request(r);
                }
            }
        }
    }
}

