/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.ArrayList;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import rx.Observable;
import rx.Producer;
import rx.Subscriber;
import rx.Subscription;
import rx.exceptions.Exceptions;
import rx.functions.Action0;
import rx.functions.Action1;
import rx.functions.Func1;
import rx.internal.operators.BackpressureUtils;
import rx.internal.operators.NotificationLite;
import rx.internal.producers.ProducerArbiter;
import rx.internal.util.RxRingBuffer;
import rx.internal.util.UtilityFunctions;
import rx.observables.GroupedObservable;
import rx.observers.Subscribers;
import rx.plugins.RxJavaHooks;
import rx.subscriptions.Subscriptions;

@Deprecated
public final class OperatorGroupBy<T, K, V>
implements Observable.Operator<GroupedObservable<K, V>, T> {
    final Func1<? super T, ? extends K> keySelector;
    final Func1<? super T, ? extends V> valueSelector;
    final int bufferSize;
    final boolean delayError;
    final Func1<Action1<K>, Map<K, Object>> mapFactory;

    public OperatorGroupBy(Func1<? super T, ? extends K> keySelector) {
        this(keySelector, UtilityFunctions.identity(), RxRingBuffer.SIZE, false, null);
    }

    public OperatorGroupBy(Func1<? super T, ? extends K> keySelector, Func1<? super T, ? extends V> valueSelector) {
        this(keySelector, valueSelector, RxRingBuffer.SIZE, false, null);
    }

    public OperatorGroupBy(Func1<? super T, ? extends K> keySelector, Func1<? super T, ? extends V> valueSelector, Func1<Action1<K>, Map<K, Object>> mapFactory) {
        this(keySelector, valueSelector, RxRingBuffer.SIZE, false, mapFactory);
    }

    public OperatorGroupBy(Func1<? super T, ? extends K> keySelector, Func1<? super T, ? extends V> valueSelector, int bufferSize, boolean delayError, Func1<Action1<K>, Map<K, Object>> mapFactory) {
        this.keySelector = keySelector;
        this.valueSelector = valueSelector;
        this.bufferSize = bufferSize;
        this.delayError = delayError;
        this.mapFactory = mapFactory;
    }

    @Override
    public Subscriber<? super T> call(Subscriber<? super GroupedObservable<K, V>> child) {
        GroupBySubscriber<? super T, ? extends K, ? extends V> parent;
        try {
            parent = new GroupBySubscriber<T, K, V>(child, this.keySelector, this.valueSelector, this.bufferSize, this.delayError, this.mapFactory);
        }
        catch (Throwable ex) {
            Exceptions.throwOrReport(ex, child);
            Subscriber parent2 = Subscribers.empty();
            parent2.unsubscribe();
            return parent2;
        }
        child.add(Subscriptions.create(new Action0(){

            @Override
            public void call() {
                parent.cancel();
            }
        }));
        child.setProducer(parent.producer);
        return parent;
    }

    static final class State<T, K>
    extends AtomicInteger
    implements Producer,
    Subscription,
    Observable.OnSubscribe<T> {
        private static final long serialVersionUID = -3852313036005250360L;
        final K key;
        final Queue<Object> queue = new ConcurrentLinkedQueue<Object>();
        final GroupBySubscriber<?, K, T> parent;
        final boolean delayError;
        final AtomicLong requested;
        volatile boolean done;
        Throwable error;
        final AtomicBoolean cancelled;
        final AtomicReference<Subscriber<? super T>> actual;
        final AtomicBoolean once;

        public State(int bufferSize, GroupBySubscriber<?, K, T> parent, K key2, boolean delayError) {
            this.parent = parent;
            this.key = key2;
            this.delayError = delayError;
            this.cancelled = new AtomicBoolean();
            this.actual = new AtomicReference();
            this.once = new AtomicBoolean();
            this.requested = new AtomicLong();
        }

        @Override
        public void request(long n) {
            if (n < 0L) {
                throw new IllegalArgumentException("n >= required but it was " + n);
            }
            if (n != 0L) {
                BackpressureUtils.getAndAddRequest(this.requested, n);
                this.drain();
            }
        }

        @Override
        public boolean isUnsubscribed() {
            return this.cancelled.get();
        }

        @Override
        public void unsubscribe() {
            if (this.cancelled.compareAndSet(false, true) && this.getAndIncrement() == 0) {
                this.parent.cancel(this.key);
            }
        }

        @Override
        public void call(Subscriber<? super T> s2) {
            if (this.once.compareAndSet(false, true)) {
                s2.add(this);
                s2.setProducer(this);
                this.actual.lazySet(s2);
                this.drain();
            } else {
                s2.onError(new IllegalStateException("Only one Subscriber allowed!"));
            }
        }

        public void onNext(T t3) {
            if (t3 == null) {
                this.error = new NullPointerException();
                this.done = true;
            } else {
                this.queue.offer(NotificationLite.next(t3));
            }
            this.drain();
        }

        public void onError(Throwable e2) {
            this.error = e2;
            this.done = true;
            this.drain();
        }

        public void onComplete() {
            this.done = true;
            this.drain();
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            Queue<Object> q = this.queue;
            boolean delayError = this.delayError;
            Subscriber a = this.actual.get();
            while (true) {
                if (a != null) {
                    long e2;
                    if (this.checkTerminated(this.done, q.isEmpty(), a, delayError)) {
                        return;
                    }
                    long r = this.requested.get();
                    for (e2 = 0L; e2 != r; ++e2) {
                        boolean empty2;
                        boolean d = this.done;
                        Object v = q.poll();
                        boolean bl = empty2 = v == null;
                        if (this.checkTerminated(d, empty2, a, delayError)) {
                            return;
                        }
                        if (empty2) break;
                        a.onNext(NotificationLite.getValue(v));
                    }
                    if (e2 != 0L) {
                        if (r != Long.MAX_VALUE) {
                            BackpressureUtils.produced(this.requested, e2);
                        }
                        this.parent.s.request(e2);
                    }
                }
                if ((missed = this.addAndGet(-missed)) == 0) break;
                if (a != null) continue;
                a = this.actual.get();
            }
        }

        boolean checkTerminated(boolean d, boolean empty2, Subscriber<? super T> a, boolean delayError) {
            if (this.cancelled.get()) {
                this.queue.clear();
                this.parent.cancel(this.key);
                return true;
            }
            if (d) {
                if (delayError) {
                    if (empty2) {
                        Throwable e2 = this.error;
                        if (e2 != null) {
                            a.onError(e2);
                        } else {
                            a.onCompleted();
                        }
                        return true;
                    }
                } else {
                    Throwable e3 = this.error;
                    if (e3 != null) {
                        this.queue.clear();
                        a.onError(e3);
                        return true;
                    }
                    if (empty2) {
                        a.onCompleted();
                        return true;
                    }
                }
            }
            return false;
        }
    }

    static final class GroupedUnicast<K, T>
    extends GroupedObservable<K, T> {
        final State<T, K> state;

        public static <T, K> GroupedUnicast<K, T> createWith(K key2, int bufferSize, GroupBySubscriber<?, K, T> parent, boolean delayError) {
            State<T, K> state = new State<T, K>(bufferSize, parent, key2, delayError);
            return new GroupedUnicast<K, T>(key2, state);
        }

        protected GroupedUnicast(K key2, State<T, K> state) {
            super(key2, state);
            this.state = state;
        }

        public void onNext(T t3) {
            this.state.onNext(t3);
        }

        public void onError(Throwable e2) {
            this.state.onError(e2);
        }

        public void onComplete() {
            this.state.onComplete();
        }
    }

    public static final class GroupBySubscriber<T, K, V>
    extends Subscriber<T> {
        final Subscriber<? super GroupedObservable<K, V>> actual;
        final Func1<? super T, ? extends K> keySelector;
        final Func1<? super T, ? extends V> valueSelector;
        final int bufferSize;
        final boolean delayError;
        final Map<Object, GroupedUnicast<K, V>> groups;
        final Map<Object, GroupedUnicast<K, V>> groupsCopy;
        final Queue<GroupedObservable<K, V>> queue;
        final GroupByProducer producer;
        final Queue<K> evictedKeys;
        static final Object NULL_KEY = new Object();
        final ProducerArbiter s;
        final AtomicBoolean cancelled;
        final AtomicLong requested;
        final AtomicInteger groupCount;
        Throwable error;
        volatile boolean done;
        final AtomicInteger wip;

        public GroupBySubscriber(Subscriber<? super GroupedObservable<K, V>> actual, Func1<? super T, ? extends K> keySelector, Func1<? super T, ? extends V> valueSelector, int bufferSize, boolean delayError, Func1<Action1<K>, Map<K, Object>> mapFactory) {
            this.actual = actual;
            this.keySelector = keySelector;
            this.valueSelector = valueSelector;
            this.bufferSize = bufferSize;
            this.delayError = delayError;
            this.queue = new ConcurrentLinkedQueue<GroupedObservable<K, V>>();
            this.s = new ProducerArbiter();
            this.s.request(bufferSize);
            this.producer = new GroupByProducer(this);
            this.cancelled = new AtomicBoolean();
            this.requested = new AtomicLong();
            this.groupCount = new AtomicInteger(1);
            this.wip = new AtomicInteger();
            if (mapFactory == null) {
                this.groups = new ConcurrentHashMap<Object, GroupedUnicast<K, V>>();
                this.evictedKeys = null;
            } else {
                this.evictedKeys = new ConcurrentLinkedQueue<K>();
                this.groups = this.createMap(mapFactory, new EvictionAction<K>(this.evictedKeys));
            }
            this.groupsCopy = new ConcurrentHashMap<Object, GroupedUnicast<K, V>>();
        }

        private Map<Object, GroupedUnicast<K, V>> createMap(Func1<Action1<K>, Map<K, Object>> mapFactory, Action1<K> evictionAction) {
            return mapFactory.call(evictionAction);
        }

        @Override
        public void setProducer(Producer s2) {
            this.s.setProducer(s2);
        }

        @Override
        public void onNext(T t3) {
            V v;
            K key2;
            if (this.done) {
                return;
            }
            Queue<GroupedObservable<K, V>> q = this.queue;
            Subscriber<? super GroupedObservable<K, V>> a = this.actual;
            try {
                key2 = this.keySelector.call(t3);
            }
            catch (Throwable ex) {
                this.unsubscribe();
                this.errorAll(a, q, ex);
                return;
            }
            boolean newGroup = false;
            Object mapKey = key2 != null ? key2 : NULL_KEY;
            GroupedUnicast<K, Object> group = this.groups.get(mapKey);
            if (group == null) {
                if (!this.cancelled.get()) {
                    group = GroupedUnicast.createWith(key2, this.bufferSize, this, this.delayError);
                    this.groups.put(mapKey, group);
                    if (this.evictedKeys != null) {
                        this.groupsCopy.put(mapKey, group);
                    }
                    this.groupCount.getAndIncrement();
                    newGroup = true;
                } else {
                    return;
                }
            }
            try {
                v = this.valueSelector.call(t3);
            }
            catch (Throwable ex) {
                this.unsubscribe();
                this.errorAll(a, q, ex);
                return;
            }
            group.onNext(v);
            if (this.evictedKeys != null) {
                K evictedKey;
                while ((evictedKey = this.evictedKeys.poll()) != null) {
                    GroupedUnicast<K, V> g2 = this.groupsCopy.remove(evictedKey);
                    if (g2 == null) continue;
                    g2.onComplete();
                }
            }
            if (newGroup) {
                q.offer(group);
                this.drain();
            }
        }

        @Override
        public void onError(Throwable t3) {
            if (this.done) {
                RxJavaHooks.onError(t3);
                return;
            }
            this.error = t3;
            this.done = true;
            this.groupCount.decrementAndGet();
            this.drain();
        }

        @Override
        public void onCompleted() {
            if (this.done) {
                return;
            }
            for (GroupedUnicast<K, V> e2 : this.groups.values()) {
                e2.onComplete();
            }
            this.groups.clear();
            if (this.evictedKeys != null) {
                this.groupsCopy.clear();
                this.evictedKeys.clear();
            }
            this.done = true;
            this.groupCount.decrementAndGet();
            this.drain();
        }

        public void requestMore(long n) {
            if (n < 0L) {
                throw new IllegalArgumentException("n >= 0 required but it was " + n);
            }
            BackpressureUtils.getAndAddRequest(this.requested, n);
            this.drain();
        }

        public void cancel() {
            if (this.cancelled.compareAndSet(false, true) && this.groupCount.decrementAndGet() == 0) {
                this.unsubscribe();
            }
        }

        public void cancel(K key2) {
            Object mapKey;
            Object object = mapKey = key2 != null ? key2 : NULL_KEY;
            if (this.groups.remove(mapKey) != null && this.groupCount.decrementAndGet() == 0) {
                this.unsubscribe();
            }
            if (this.evictedKeys != null) {
                this.groupsCopy.remove(mapKey);
            }
        }

        void drain() {
            if (this.wip.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            Queue<GroupedObservable<K, V>> q = this.queue;
            Subscriber<GroupedObservable<K, V>> a = this.actual;
            do {
                long e2;
                if (this.checkTerminated(this.done, q.isEmpty(), a, q)) {
                    return;
                }
                long r = this.requested.get();
                for (e2 = 0L; e2 != r; ++e2) {
                    boolean empty2;
                    boolean d = this.done;
                    GroupedObservable<K, V> t3 = q.poll();
                    boolean bl = empty2 = t3 == null;
                    if (this.checkTerminated(d, empty2, a, q)) {
                        return;
                    }
                    if (empty2) break;
                    a.onNext(t3);
                }
                if (e2 == 0L) continue;
                if (r != Long.MAX_VALUE) {
                    BackpressureUtils.produced(this.requested, e2);
                }
                this.s.request(e2);
            } while ((missed = this.wip.addAndGet(-missed)) != 0);
        }

        void errorAll(Subscriber<? super GroupedObservable<K, V>> a, Queue<?> q, Throwable ex) {
            q.clear();
            ArrayList<GroupedUnicast<K, V>> list = new ArrayList<GroupedUnicast<K, V>>(this.groups.values());
            this.groups.clear();
            if (this.evictedKeys != null) {
                this.groupsCopy.clear();
                this.evictedKeys.clear();
            }
            for (GroupedUnicast groupedUnicast : list) {
                groupedUnicast.onError(ex);
            }
            a.onError(ex);
        }

        boolean checkTerminated(boolean d, boolean empty2, Subscriber<? super GroupedObservable<K, V>> a, Queue<?> q) {
            if (d) {
                Throwable err = this.error;
                if (err != null) {
                    this.errorAll(a, q, err);
                    return true;
                }
                if (empty2) {
                    this.actual.onCompleted();
                    return true;
                }
            }
            return false;
        }

        static class EvictionAction<K>
        implements Action1<K> {
            final Queue<K> evictedKeys;

            EvictionAction(Queue<K> evictedKeys) {
                this.evictedKeys = evictedKeys;
            }

            @Override
            public void call(K key2) {
                this.evictedKeys.offer(key2);
            }
        }
    }

    public static final class GroupByProducer
    implements Producer {
        final GroupBySubscriber<?, ?, ?> parent;

        public GroupByProducer(GroupBySubscriber<?, ?, ?> parent) {
            this.parent = parent;
        }

        @Override
        public void request(long n) {
            this.parent.requestMore(n);
        }
    }
}

