/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import rx.Observable;
import rx.Subscriber;
import rx.exceptions.Exceptions;
import rx.functions.Action0;
import rx.plugins.RxJavaHooks;

public final class OperatorDoAfterTerminate<T>
implements Observable.Operator<T, T> {
    final Action0 action;

    public OperatorDoAfterTerminate(Action0 action) {
        if (action == null) {
            throw new NullPointerException("Action can not be null");
        }
        this.action = action;
    }

    @Override
    public Subscriber<? super T> call(final Subscriber<? super T> child) {
        return new Subscriber<T>(child){

            @Override
            public void onNext(T t3) {
                child.onNext(t3);
            }

            @Override
            public void onError(Throwable e2) {
                try {
                    child.onError(e2);
                }
                finally {
                    this.callAction();
                }
            }

            @Override
            public void onCompleted() {
                try {
                    child.onCompleted();
                }
                finally {
                    this.callAction();
                }
            }

            void callAction() {
                try {
                    OperatorDoAfterTerminate.this.action.call();
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal(ex);
                    RxJavaHooks.onError(ex);
                }
            }
        };
    }
}

