/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import rx.Observable;
import rx.Subscriber;
import rx.exceptions.Exceptions;
import rx.functions.Func1;
import rx.observers.SerializedSubscriber;
import rx.subscriptions.CompositeSubscription;

public final class OperatorBufferWithStartEndObservable<T, TOpening, TClosing>
implements Observable.Operator<List<T>, T> {
    final Observable<? extends TOpening> bufferOpening;
    final Func1<? super TOpening, ? extends Observable<? extends TClosing>> bufferClosing;

    public OperatorBufferWithStartEndObservable(Observable<? extends TOpening> bufferOpenings, Func1<? super TOpening, ? extends Observable<? extends TClosing>> bufferClosingSelector) {
        this.bufferOpening = bufferOpenings;
        this.bufferClosing = bufferClosingSelector;
    }

    @Override
    public Subscriber<? super T> call(Subscriber<? super List<T>> child) {
        final BufferingSubscriber s2 = new BufferingSubscriber(new SerializedSubscriber<List<T>>(child));
        Subscriber openSubscriber = new Subscriber<TOpening>(){

            @Override
            public void onNext(TOpening t3) {
                s2.startBuffer(t3);
            }

            @Override
            public void onError(Throwable e2) {
                s2.onError(e2);
            }

            @Override
            public void onCompleted() {
                s2.onCompleted();
            }
        };
        child.add(openSubscriber);
        child.add(s2);
        this.bufferOpening.unsafeSubscribe(openSubscriber);
        return s2;
    }

    final class BufferingSubscriber
    extends Subscriber<T> {
        final Subscriber<? super List<T>> child;
        final List<List<T>> chunks;
        boolean done;
        final CompositeSubscription closingSubscriptions;

        public BufferingSubscriber(Subscriber<? super List<T>> child) {
            this.child = child;
            this.chunks = new LinkedList();
            this.closingSubscriptions = new CompositeSubscription();
            this.add(this.closingSubscriptions);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onNext(T t3) {
            BufferingSubscriber bufferingSubscriber = this;
            synchronized (bufferingSubscriber) {
                for (List chunk2 : this.chunks) {
                    chunk2.add(t3);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onError(Throwable e2) {
            BufferingSubscriber bufferingSubscriber = this;
            synchronized (bufferingSubscriber) {
                if (this.done) {
                    return;
                }
                this.done = true;
                this.chunks.clear();
            }
            this.child.onError(e2);
            this.unsubscribe();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCompleted() {
            try {
                LinkedList toEmit;
                BufferingSubscriber bufferingSubscriber = this;
                synchronized (bufferingSubscriber) {
                    if (this.done) {
                        return;
                    }
                    this.done = true;
                    toEmit = new LinkedList(this.chunks);
                    this.chunks.clear();
                }
                for (List list : toEmit) {
                    this.child.onNext(list);
                }
            }
            catch (Throwable t3) {
                Exceptions.throwOrReport(t3, this.child);
                return;
            }
            this.child.onCompleted();
            this.unsubscribe();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void startBuffer(TOpening v) {
            Observable cobs;
            final ArrayList chunk2 = new ArrayList();
            BufferingSubscriber bufferingSubscriber = this;
            synchronized (bufferingSubscriber) {
                if (this.done) {
                    return;
                }
                this.chunks.add(chunk2);
            }
            try {
                cobs = OperatorBufferWithStartEndObservable.this.bufferClosing.call(v);
            }
            catch (Throwable t3) {
                Exceptions.throwOrReport(t3, this);
                return;
            }
            Subscriber closeSubscriber = new Subscriber<TClosing>(){

                @Override
                public void onNext(TClosing t3) {
                    BufferingSubscriber.this.closingSubscriptions.remove(this);
                    BufferingSubscriber.this.endBuffer(chunk2);
                }

                @Override
                public void onError(Throwable e2) {
                    BufferingSubscriber.this.onError(e2);
                }

                @Override
                public void onCompleted() {
                    BufferingSubscriber.this.closingSubscriptions.remove(this);
                    BufferingSubscriber.this.endBuffer(chunk2);
                }
            };
            this.closingSubscriptions.add(closeSubscriber);
            cobs.unsafeSubscribe(closeSubscriber);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void endBuffer(List<T> toEnd) {
            boolean canEnd = false;
            BufferingSubscriber bufferingSubscriber = this;
            synchronized (bufferingSubscriber) {
                if (this.done) {
                    return;
                }
                Iterator it = this.chunks.iterator();
                while (it.hasNext()) {
                    List chunk2 = it.next();
                    if (chunk2 != toEnd) continue;
                    canEnd = true;
                    it.remove();
                    break;
                }
            }
            if (canEnd) {
                this.child.onNext(toEnd);
            }
        }
    }
}

