/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import rx.Observable;
import rx.Subscriber;
import rx.exceptions.Exceptions;
import rx.functions.Func1;
import rx.internal.producers.SingleDelayedProducer;
import rx.plugins.RxJavaHooks;

public final class OperatorAny<T>
implements Observable.Operator<Boolean, T> {
    final Func1<? super T, Boolean> predicate;
    final boolean returnOnEmpty;

    public OperatorAny(Func1<? super T, Boolean> predicate, boolean returnOnEmpty) {
        this.predicate = predicate;
        this.returnOnEmpty = returnOnEmpty;
    }

    @Override
    public Subscriber<? super T> call(final Subscriber<? super Boolean> child) {
        final SingleDelayedProducer<? super Boolean> producer = new SingleDelayedProducer<Boolean>(child);
        Subscriber s2 = new Subscriber<T>(){
            boolean hasElements;
            boolean done;

            @Override
            public void onNext(T t3) {
                boolean result2;
                if (this.done) {
                    return;
                }
                this.hasElements = true;
                try {
                    result2 = OperatorAny.this.predicate.call(t3);
                }
                catch (Throwable e2) {
                    Exceptions.throwOrReport(e2, this, t3);
                    return;
                }
                if (result2) {
                    this.done = true;
                    producer.setValue(!OperatorAny.this.returnOnEmpty);
                    this.unsubscribe();
                }
            }

            @Override
            public void onError(Throwable e2) {
                if (!this.done) {
                    this.done = true;
                    child.onError(e2);
                } else {
                    RxJavaHooks.onError(e2);
                }
            }

            @Override
            public void onCompleted() {
                if (!this.done) {
                    this.done = true;
                    if (this.hasElements) {
                        producer.setValue(false);
                    } else {
                        producer.setValue(OperatorAny.this.returnOnEmpty);
                    }
                }
            }
        };
        child.add(s2);
        child.setProducer(producer);
        return s2;
    }
}

