/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.concurrent.TimeUnit;
import rx.Observable;
import rx.Scheduler;
import rx.Subscriber;
import rx.exceptions.Exceptions;
import rx.functions.Action0;

public final class OnSubscribeTimerPeriodically
implements Observable.OnSubscribe<Long> {
    final long initialDelay;
    final long period;
    final TimeUnit unit;
    final Scheduler scheduler;

    public OnSubscribeTimerPeriodically(long initialDelay, long period2, TimeUnit unit, Scheduler scheduler) {
        this.initialDelay = initialDelay;
        this.period = period2;
        this.unit = unit;
        this.scheduler = scheduler;
    }

    @Override
    public void call(final Subscriber<? super Long> child) {
        final Scheduler.Worker worker = this.scheduler.createWorker();
        child.add(worker);
        worker.schedulePeriodically(new Action0(){
            long counter;

            @Override
            public void call() {
                try {
                    child.onNext(this.counter++);
                }
                catch (Throwable e2) {
                    try {
                        worker.unsubscribe();
                    }
                    finally {
                        Exceptions.throwOrReport(e2, child);
                    }
                }
            }
        }, this.initialDelay, this.period, this.unit);
    }
}

