/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import rx.Observable;
import rx.Producer;
import rx.Scheduler;
import rx.Subscriber;
import rx.Subscription;
import rx.functions.Action0;
import rx.internal.producers.ProducerArbiter;
import rx.internal.subscriptions.SequentialSubscription;
import rx.plugins.RxJavaHooks;

public final class OnSubscribeTimeoutTimedWithFallback<T>
implements Observable.OnSubscribe<T> {
    final Observable<T> source;
    final long timeout;
    final TimeUnit unit;
    final Scheduler scheduler;
    final Observable<? extends T> fallback;

    public OnSubscribeTimeoutTimedWithFallback(Observable<T> source2, long timeout, TimeUnit unit, Scheduler scheduler, Observable<? extends T> fallback) {
        this.source = source2;
        this.timeout = timeout;
        this.unit = unit;
        this.scheduler = scheduler;
        this.fallback = fallback;
    }

    @Override
    public void call(Subscriber<? super T> t3) {
        TimeoutMainSubscriber<T> parent = new TimeoutMainSubscriber<T>(t3, this.timeout, this.unit, this.scheduler.createWorker(), this.fallback);
        t3.add(parent.upstream);
        t3.setProducer(parent.arbiter);
        parent.startTimeout(0L);
        this.source.subscribe((Subscriber<? extends T>)parent);
    }

    static final class FallbackSubscriber<T>
    extends Subscriber<T> {
        final Subscriber<? super T> actual;
        final ProducerArbiter arbiter;

        FallbackSubscriber(Subscriber<? super T> actual, ProducerArbiter arbiter) {
            this.actual = actual;
            this.arbiter = arbiter;
        }

        @Override
        public void onNext(T t3) {
            this.actual.onNext(t3);
        }

        @Override
        public void onError(Throwable e2) {
            this.actual.onError(e2);
        }

        @Override
        public void onCompleted() {
            this.actual.onCompleted();
        }

        @Override
        public void setProducer(Producer p) {
            this.arbiter.setProducer(p);
        }
    }

    static final class TimeoutMainSubscriber<T>
    extends Subscriber<T> {
        final Subscriber<? super T> actual;
        final long timeout;
        final TimeUnit unit;
        final Scheduler.Worker worker;
        final Observable<? extends T> fallback;
        final ProducerArbiter arbiter;
        final AtomicLong index;
        final SequentialSubscription task;
        final SequentialSubscription upstream;
        long consumed;

        TimeoutMainSubscriber(Subscriber<? super T> actual, long timeout, TimeUnit unit, Scheduler.Worker worker, Observable<? extends T> fallback) {
            this.actual = actual;
            this.timeout = timeout;
            this.unit = unit;
            this.worker = worker;
            this.fallback = fallback;
            this.arbiter = new ProducerArbiter();
            this.index = new AtomicLong();
            this.task = new SequentialSubscription();
            this.upstream = new SequentialSubscription(this);
            this.add(worker);
            this.add(this.task);
        }

        @Override
        public void onNext(T t3) {
            long idx = this.index.get();
            if (idx == Long.MAX_VALUE || !this.index.compareAndSet(idx, idx + 1L)) {
                return;
            }
            Subscription s2 = (Subscription)this.task.get();
            if (s2 != null) {
                s2.unsubscribe();
            }
            ++this.consumed;
            this.actual.onNext(t3);
            this.startTimeout(idx + 1L);
        }

        void startTimeout(long nextIdx) {
            this.task.replace(this.worker.schedule(new TimeoutTask(nextIdx), this.timeout, this.unit));
        }

        @Override
        public void onError(Throwable e2) {
            if (this.index.getAndSet(Long.MAX_VALUE) != Long.MAX_VALUE) {
                this.task.unsubscribe();
                this.actual.onError(e2);
                this.worker.unsubscribe();
            } else {
                RxJavaHooks.onError(e2);
            }
        }

        @Override
        public void onCompleted() {
            if (this.index.getAndSet(Long.MAX_VALUE) != Long.MAX_VALUE) {
                this.task.unsubscribe();
                this.actual.onCompleted();
                this.worker.unsubscribe();
            }
        }

        @Override
        public void setProducer(Producer p) {
            this.arbiter.setProducer(p);
        }

        void onTimeout(long idx) {
            if (!this.index.compareAndSet(idx, Long.MAX_VALUE)) {
                return;
            }
            this.unsubscribe();
            if (this.fallback == null) {
                this.actual.onError(new TimeoutException());
            } else {
                FallbackSubscriber<? super T> fallbackSubscriber;
                long c = this.consumed;
                if (c != 0L) {
                    this.arbiter.produced(c);
                }
                if (this.upstream.replace(fallbackSubscriber = new FallbackSubscriber<T>(this.actual, this.arbiter))) {
                    this.fallback.subscribe((Subscriber<? super T>)fallbackSubscriber);
                }
            }
        }

        final class TimeoutTask
        implements Action0 {
            final long idx;

            TimeoutTask(long idx) {
                this.idx = idx;
            }

            @Override
            public void call() {
                TimeoutMainSubscriber.this.onTimeout(this.idx);
            }
        }
    }
}

