/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import rx.Observable;
import rx.Producer;
import rx.Subscriber;
import rx.Subscription;
import rx.exceptions.Exceptions;
import rx.functions.Func1;
import rx.internal.operators.OnSubscribeTimeoutTimedWithFallback;
import rx.internal.producers.ProducerArbiter;
import rx.internal.subscriptions.SequentialSubscription;
import rx.plugins.RxJavaHooks;

public final class OnSubscribeTimeoutSelectorWithFallback<T, U, V>
implements Observable.OnSubscribe<T> {
    final Observable<T> source;
    final Observable<U> firstTimeoutIndicator;
    final Func1<? super T, ? extends Observable<V>> itemTimeoutIndicator;
    final Observable<? extends T> fallback;

    public OnSubscribeTimeoutSelectorWithFallback(Observable<T> source2, Observable<U> firstTimeoutIndicator, Func1<? super T, ? extends Observable<V>> itemTimeoutIndicator, Observable<? extends T> fallback) {
        this.source = source2;
        this.firstTimeoutIndicator = firstTimeoutIndicator;
        this.itemTimeoutIndicator = itemTimeoutIndicator;
        this.fallback = fallback;
    }

    @Override
    public void call(Subscriber<? super T> t3) {
        TimeoutMainSubscriber<T> parent = new TimeoutMainSubscriber<T>(t3, this.itemTimeoutIndicator, this.fallback);
        t3.add(parent.upstream);
        t3.setProducer(parent.arbiter);
        parent.startFirst(this.firstTimeoutIndicator);
        this.source.subscribe((Subscriber<? extends T>)parent);
    }

    static final class TimeoutMainSubscriber<T>
    extends Subscriber<T> {
        final Subscriber<? super T> actual;
        final Func1<? super T, ? extends Observable<?>> itemTimeoutIndicator;
        final Observable<? extends T> fallback;
        final ProducerArbiter arbiter;
        final AtomicLong index;
        final SequentialSubscription task;
        final SequentialSubscription upstream;
        long consumed;

        TimeoutMainSubscriber(Subscriber<? super T> actual, Func1<? super T, ? extends Observable<?>> itemTimeoutIndicator, Observable<? extends T> fallback) {
            this.actual = actual;
            this.itemTimeoutIndicator = itemTimeoutIndicator;
            this.fallback = fallback;
            this.arbiter = new ProducerArbiter();
            this.index = new AtomicLong();
            this.task = new SequentialSubscription();
            this.upstream = new SequentialSubscription(this);
            this.add(this.task);
        }

        @Override
        public void onNext(T t3) {
            Observable<?> timeoutObservable;
            long idx = this.index.get();
            if (idx == Long.MAX_VALUE || !this.index.compareAndSet(idx, idx + 1L)) {
                return;
            }
            Subscription s2 = (Subscription)this.task.get();
            if (s2 != null) {
                s2.unsubscribe();
            }
            this.actual.onNext(t3);
            ++this.consumed;
            try {
                timeoutObservable = this.itemTimeoutIndicator.call(t3);
                if (timeoutObservable == null) {
                    throw new NullPointerException("The itemTimeoutIndicator returned a null Observable");
                }
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                this.unsubscribe();
                this.index.getAndSet(Long.MAX_VALUE);
                this.actual.onError(ex);
                return;
            }
            TimeoutConsumer tc = new TimeoutConsumer(idx + 1L);
            if (this.task.replace(tc)) {
                timeoutObservable.subscribe(tc);
            }
        }

        void startFirst(Observable<?> firstTimeoutIndicator) {
            TimeoutConsumer tc;
            if (firstTimeoutIndicator != null && this.task.replace(tc = new TimeoutConsumer(0L))) {
                firstTimeoutIndicator.subscribe(tc);
            }
        }

        @Override
        public void onError(Throwable e2) {
            if (this.index.getAndSet(Long.MAX_VALUE) != Long.MAX_VALUE) {
                this.task.unsubscribe();
                this.actual.onError(e2);
            } else {
                RxJavaHooks.onError(e2);
            }
        }

        @Override
        public void onCompleted() {
            if (this.index.getAndSet(Long.MAX_VALUE) != Long.MAX_VALUE) {
                this.task.unsubscribe();
                this.actual.onCompleted();
            }
        }

        @Override
        public void setProducer(Producer p) {
            this.arbiter.setProducer(p);
        }

        void onTimeout(long idx) {
            if (!this.index.compareAndSet(idx, Long.MAX_VALUE)) {
                return;
            }
            this.unsubscribe();
            if (this.fallback == null) {
                this.actual.onError(new TimeoutException());
            } else {
                OnSubscribeTimeoutTimedWithFallback.FallbackSubscriber<? super T> fallbackSubscriber;
                long c = this.consumed;
                if (c != 0L) {
                    this.arbiter.produced(c);
                }
                if (this.upstream.replace(fallbackSubscriber = new OnSubscribeTimeoutTimedWithFallback.FallbackSubscriber<T>(this.actual, this.arbiter))) {
                    this.fallback.subscribe((Subscriber<? super T>)fallbackSubscriber);
                }
            }
        }

        void onTimeoutError(long idx, Throwable ex) {
            if (this.index.compareAndSet(idx, Long.MAX_VALUE)) {
                this.unsubscribe();
                this.actual.onError(ex);
            } else {
                RxJavaHooks.onError(ex);
            }
        }

        final class TimeoutConsumer
        extends Subscriber<Object> {
            final long idx;
            boolean done;

            TimeoutConsumer(long idx) {
                this.idx = idx;
            }

            @Override
            public void onNext(Object t3) {
                if (!this.done) {
                    this.done = true;
                    this.unsubscribe();
                    TimeoutMainSubscriber.this.onTimeout(this.idx);
                }
            }

            @Override
            public void onError(Throwable e2) {
                if (!this.done) {
                    this.done = true;
                    TimeoutMainSubscriber.this.onTimeoutError(this.idx, e2);
                } else {
                    RxJavaHooks.onError(e2);
                }
            }

            @Override
            public void onCompleted() {
                if (!this.done) {
                    this.done = true;
                    TimeoutMainSubscriber.this.onTimeout(this.idx);
                }
            }
        }
    }
}

