/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import rx.Observable;
import rx.Observer;
import rx.Subscriber;
import rx.Subscription;
import rx.exceptions.Exceptions;
import rx.functions.Func1;
import rx.functions.Func2;
import rx.observers.SerializedObserver;
import rx.observers.SerializedSubscriber;
import rx.subjects.PublishSubject;
import rx.subscriptions.CompositeSubscription;
import rx.subscriptions.RefCountSubscription;

public final class OnSubscribeGroupJoin<T1, T2, D1, D2, R>
implements Observable.OnSubscribe<R> {
    final Observable<T1> left;
    final Observable<T2> right;
    final Func1<? super T1, ? extends Observable<D1>> leftDuration;
    final Func1<? super T2, ? extends Observable<D2>> rightDuration;
    final Func2<? super T1, ? super Observable<T2>, ? extends R> resultSelector;

    public OnSubscribeGroupJoin(Observable<T1> left2, Observable<T2> right2, Func1<? super T1, ? extends Observable<D1>> leftDuration, Func1<? super T2, ? extends Observable<D2>> rightDuration, Func2<? super T1, ? super Observable<T2>, ? extends R> resultSelector) {
        this.left = left2;
        this.right = right2;
        this.leftDuration = leftDuration;
        this.rightDuration = rightDuration;
        this.resultSelector = resultSelector;
    }

    @Override
    public void call(Subscriber<? super R> child) {
        ResultManager ro = new ResultManager(new SerializedSubscriber<R>(child));
        child.add(ro);
        ro.init();
    }

    static final class WindowObservableFunc<T>
    implements Observable.OnSubscribe<T> {
        final RefCountSubscription refCount;
        final Observable<T> underlying;

        public WindowObservableFunc(Observable<T> underlying, RefCountSubscription refCount) {
            this.refCount = refCount;
            this.underlying = underlying;
        }

        @Override
        public void call(Subscriber<? super T> t12) {
            Subscription ref2 = this.refCount.get();
            WindowSubscriber wo = new WindowSubscriber(t12, ref2);
            wo.add(ref2);
            this.underlying.unsafeSubscribe(wo);
        }

        final class WindowSubscriber
        extends Subscriber<T> {
            final Subscriber<? super T> subscriber;
            private final Subscription ref;

            public WindowSubscriber(Subscriber<? super T> subscriber, Subscription ref2) {
                super(subscriber);
                this.subscriber = subscriber;
                this.ref = ref2;
            }

            @Override
            public void onNext(T args2) {
                this.subscriber.onNext(args2);
            }

            @Override
            public void onError(Throwable e2) {
                this.subscriber.onError(e2);
                this.ref.unsubscribe();
            }

            @Override
            public void onCompleted() {
                this.subscriber.onCompleted();
                this.ref.unsubscribe();
            }
        }
    }

    final class ResultManager
    extends HashMap<Integer, Observer<T2>>
    implements Subscription {
        private static final long serialVersionUID = -3035156013812425335L;
        final RefCountSubscription cancel;
        final Subscriber<? super R> subscriber;
        final CompositeSubscription group;
        int leftIds;
        int rightIds;
        final Map<Integer, T2> rightMap = new HashMap();
        boolean leftDone;
        boolean rightDone;

        public ResultManager(Subscriber<? super R> subscriber) {
            this.subscriber = subscriber;
            this.group = new CompositeSubscription();
            this.cancel = new RefCountSubscription(this.group);
        }

        public void init() {
            LeftObserver s1 = new LeftObserver();
            RightObserver s2 = new RightObserver();
            this.group.add(s1);
            this.group.add(s2);
            OnSubscribeGroupJoin.this.left.unsafeSubscribe(s1);
            OnSubscribeGroupJoin.this.right.unsafeSubscribe(s2);
        }

        @Override
        public void unsubscribe() {
            this.cancel.unsubscribe();
        }

        @Override
        public boolean isUnsubscribed() {
            return this.cancel.isUnsubscribed();
        }

        Map<Integer, Observer<T2>> leftMap() {
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void errorAll(Throwable e2) {
            ArrayList list;
            ResultManager resultManager = this;
            synchronized (resultManager) {
                list = new ArrayList(this.leftMap().values());
                this.leftMap().clear();
                this.rightMap.clear();
            }
            for (Observer observer : list) {
                observer.onError(e2);
            }
            this.subscriber.onError(e2);
            this.cancel.unsubscribe();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void errorMain(Throwable e2) {
            ResultManager resultManager = this;
            synchronized (resultManager) {
                this.leftMap().clear();
                this.rightMap.clear();
            }
            this.subscriber.onError(e2);
            this.cancel.unsubscribe();
        }

        void complete(List<Observer<T2>> list) {
            if (list != null) {
                for (Observer o : list) {
                    o.onCompleted();
                }
                this.subscriber.onCompleted();
                this.cancel.unsubscribe();
            }
        }

        final class RightDurationObserver
        extends Subscriber<D2> {
            final int id;
            boolean once = true;

            public RightDurationObserver(int id) {
                this.id = id;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCompleted() {
                if (this.once) {
                    this.once = false;
                    ResultManager resultManager = ResultManager.this;
                    synchronized (resultManager) {
                        ResultManager.this.rightMap.remove(this.id);
                    }
                    ResultManager.this.group.remove(this);
                }
            }

            @Override
            public void onError(Throwable e2) {
                ResultManager.this.errorMain(e2);
            }

            @Override
            public void onNext(D2 args2) {
                this.onCompleted();
            }
        }

        final class LeftDurationObserver
        extends Subscriber<D1> {
            final int id;
            boolean once = true;

            public LeftDurationObserver(int id) {
                this.id = id;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCompleted() {
                if (this.once) {
                    Observer gr;
                    this.once = false;
                    ResultManager resultManager = ResultManager.this;
                    synchronized (resultManager) {
                        gr = ResultManager.this.leftMap().remove(this.id);
                    }
                    if (gr != null) {
                        gr.onCompleted();
                    }
                    ResultManager.this.group.remove(this);
                }
            }

            @Override
            public void onError(Throwable e2) {
                ResultManager.this.errorMain(e2);
            }

            @Override
            public void onNext(D1 args2) {
                this.onCompleted();
            }
        }

        final class RightObserver
        extends Subscriber<T2> {
            RightObserver() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onNext(T2 args2) {
                try {
                    ArrayList list;
                    int id;
                    ResultManager resultManager = ResultManager.this;
                    synchronized (resultManager) {
                        id = ResultManager.this.rightIds++;
                        ResultManager.this.rightMap.put(id, args2);
                    }
                    Observable duration2 = OnSubscribeGroupJoin.this.rightDuration.call(args2);
                    RightDurationObserver d2 = new RightDurationObserver(id);
                    ResultManager.this.group.add(d2);
                    duration2.unsafeSubscribe(d2);
                    ResultManager resultManager2 = ResultManager.this;
                    synchronized (resultManager2) {
                        list = new ArrayList(ResultManager.this.leftMap().values());
                    }
                    for (Observer observer : list) {
                        observer.onNext(args2);
                    }
                }
                catch (Throwable t3) {
                    Exceptions.throwOrReport(t3, this);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCompleted() {
                ArrayList list = null;
                ResultManager resultManager = ResultManager.this;
                synchronized (resultManager) {
                    ResultManager.this.rightDone = true;
                    if (ResultManager.this.leftDone) {
                        list = new ArrayList(ResultManager.this.leftMap().values());
                        ResultManager.this.leftMap().clear();
                        ResultManager.this.rightMap.clear();
                    }
                }
                ResultManager.this.complete(list);
            }

            @Override
            public void onError(Throwable e2) {
                ResultManager.this.errorAll(e2);
            }
        }

        final class LeftObserver
        extends Subscriber<T1> {
            LeftObserver() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onNext(T1 args2) {
                try {
                    ArrayList rightMapValues;
                    int id;
                    PublishSubject subj = PublishSubject.create();
                    SerializedObserver subjSerial = new SerializedObserver(subj);
                    ResultManager resultManager = ResultManager.this;
                    synchronized (resultManager) {
                        id = ResultManager.this.leftIds++;
                        ResultManager.this.leftMap().put(id, subjSerial);
                    }
                    Observable window = Observable.unsafeCreate(new WindowObservableFunc(subj, ResultManager.this.cancel));
                    Observable duration2 = OnSubscribeGroupJoin.this.leftDuration.call(args2);
                    LeftDurationObserver d1 = new LeftDurationObserver(id);
                    ResultManager.this.group.add(d1);
                    duration2.unsafeSubscribe(d1);
                    Object result2 = OnSubscribeGroupJoin.this.resultSelector.call(args2, window);
                    ResultManager resultManager2 = ResultManager.this;
                    synchronized (resultManager2) {
                        rightMapValues = new ArrayList(ResultManager.this.rightMap.values());
                    }
                    ResultManager.this.subscriber.onNext(result2);
                    for (Object t22 : rightMapValues) {
                        subjSerial.onNext(t22);
                    }
                }
                catch (Throwable t3) {
                    Exceptions.throwOrReport(t3, this);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCompleted() {
                ArrayList list = null;
                ResultManager resultManager = ResultManager.this;
                synchronized (resultManager) {
                    ResultManager.this.leftDone = true;
                    if (ResultManager.this.rightDone) {
                        list = new ArrayList(ResultManager.this.leftMap().values());
                        ResultManager.this.leftMap().clear();
                        ResultManager.this.rightMap.clear();
                    }
                }
                ResultManager.this.complete(list);
            }

            @Override
            public void onError(Throwable e2) {
                ResultManager.this.errorAll(e2);
            }
        }
    }
}

