/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.Arrays;
import rx.Observable;
import rx.Observer;
import rx.Subscriber;
import rx.exceptions.CompositeException;
import rx.exceptions.Exceptions;
import rx.plugins.RxJavaHooks;

public class OnSubscribeDoOnEach<T>
implements Observable.OnSubscribe<T> {
    private final Observer<? super T> doOnEachObserver;
    private final Observable<T> source;

    public OnSubscribeDoOnEach(Observable<T> source2, Observer<? super T> doOnEachObserver) {
        this.source = source2;
        this.doOnEachObserver = doOnEachObserver;
    }

    @Override
    public void call(Subscriber<? super T> subscriber) {
        this.source.unsafeSubscribe(new DoOnEachSubscriber<T>(subscriber, this.doOnEachObserver));
    }

    private static final class DoOnEachSubscriber<T>
    extends Subscriber<T> {
        private final Subscriber<? super T> subscriber;
        private final Observer<? super T> doOnEachObserver;
        private boolean done;

        DoOnEachSubscriber(Subscriber<? super T> subscriber, Observer<? super T> doOnEachObserver) {
            super(subscriber);
            this.subscriber = subscriber;
            this.doOnEachObserver = doOnEachObserver;
        }

        @Override
        public void onCompleted() {
            if (this.done) {
                return;
            }
            try {
                this.doOnEachObserver.onCompleted();
            }
            catch (Throwable e2) {
                Exceptions.throwOrReport(e2, this);
                return;
            }
            this.done = true;
            this.subscriber.onCompleted();
        }

        @Override
        public void onError(Throwable e2) {
            if (this.done) {
                RxJavaHooks.onError(e2);
                return;
            }
            this.done = true;
            try {
                this.doOnEachObserver.onError(e2);
            }
            catch (Throwable e22) {
                Exceptions.throwIfFatal(e22);
                this.subscriber.onError(new CompositeException(Arrays.asList(e2, e22)));
                return;
            }
            this.subscriber.onError(e2);
        }

        @Override
        public void onNext(T value) {
            if (this.done) {
                return;
            }
            try {
                this.doOnEachObserver.onNext(value);
            }
            catch (Throwable e2) {
                Exceptions.throwOrReport(e2, this, value);
                return;
            }
            this.subscriber.onNext(value);
        }
    }
}

