/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import rx.Observable;
import rx.Subscriber;
import rx.exceptions.Exceptions;
import rx.functions.Func0;
import rx.observers.Subscribers;

public final class OnSubscribeDelaySubscriptionWithSelector<T, U>
implements Observable.OnSubscribe<T> {
    final Observable<? extends T> source;
    final Func0<? extends Observable<U>> subscriptionDelay;

    public OnSubscribeDelaySubscriptionWithSelector(Observable<? extends T> source2, Func0<? extends Observable<U>> subscriptionDelay) {
        this.source = source2;
        this.subscriptionDelay = subscriptionDelay;
    }

    @Override
    public void call(final Subscriber<? super T> child) {
        try {
            this.subscriptionDelay.call().take(1).unsafeSubscribe(new Subscriber<U>(){

                @Override
                public void onCompleted() {
                    OnSubscribeDelaySubscriptionWithSelector.this.source.unsafeSubscribe(Subscribers.wrap(child));
                }

                @Override
                public void onError(Throwable e2) {
                    child.onError(e2);
                }

                @Override
                public void onNext(U t3) {
                }
            });
        }
        catch (Throwable e2) {
            Exceptions.throwOrReport(e2, child);
        }
    }
}

