/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import rx.Observable;
import rx.Producer;
import rx.Subscriber;
import rx.Subscription;
import rx.exceptions.CompositeException;
import rx.functions.FuncN;
import rx.internal.operators.BackpressureUtils;
import rx.internal.operators.NotificationLite;
import rx.internal.util.RxRingBuffer;
import rx.internal.util.atomic.SpscLinkedArrayQueue;
import rx.plugins.RxJavaHooks;

public final class OnSubscribeCombineLatest<T, R>
implements Observable.OnSubscribe<R> {
    final Observable<? extends T>[] sources;
    final Iterable<? extends Observable<? extends T>> sourcesIterable;
    final FuncN<? extends R> combiner;
    final int bufferSize;
    final boolean delayError;

    public OnSubscribeCombineLatest(Iterable<? extends Observable<? extends T>> sourcesIterable, FuncN<? extends R> combiner) {
        this(null, sourcesIterable, combiner, RxRingBuffer.SIZE, false);
    }

    public OnSubscribeCombineLatest(Observable<? extends T>[] sources, Iterable<? extends Observable<? extends T>> sourcesIterable, FuncN<? extends R> combiner, int bufferSize, boolean delayError) {
        this.sources = sources;
        this.sourcesIterable = sourcesIterable;
        this.combiner = combiner;
        this.bufferSize = bufferSize;
        this.delayError = delayError;
    }

    @Override
    public void call(Subscriber<? super R> s2) {
        Observable<? extends T>[] sources = this.sources;
        int count2 = 0;
        if (sources == null) {
            if (this.sourcesIterable instanceof List) {
                List list = (List)this.sourcesIterable;
                sources = list.toArray(new Observable[list.size()]);
                count2 = sources.length;
            } else {
                sources = new Observable[8];
                for (Observable observable2 : this.sourcesIterable) {
                    if (count2 == sources.length) {
                        Observable[] b = new Observable[count2 + (count2 >> 2)];
                        System.arraycopy(sources, 0, b, 0, count2);
                        sources = b;
                    }
                    sources[count2++] = observable2;
                }
            }
        } else {
            count2 = sources.length;
        }
        if (count2 == 0) {
            s2.onCompleted();
            return;
        }
        LatestCoordinator<? extends T, R> lc = new LatestCoordinator<T, R>(s2, this.combiner, count2, this.bufferSize, this.delayError);
        lc.subscribe(sources);
    }

    static final class CombinerSubscriber<T, R>
    extends Subscriber<T> {
        final LatestCoordinator<T, R> parent;
        final int index;
        boolean done;

        public CombinerSubscriber(LatestCoordinator<T, R> parent, int index2) {
            this.parent = parent;
            this.index = index2;
            this.request(parent.bufferSize);
        }

        @Override
        public void onNext(T t3) {
            if (this.done) {
                return;
            }
            this.parent.combine(NotificationLite.next(t3), this.index);
        }

        @Override
        public void onError(Throwable t3) {
            if (this.done) {
                RxJavaHooks.onError(t3);
                return;
            }
            this.parent.onError(t3);
            this.done = true;
            this.parent.combine(null, this.index);
        }

        @Override
        public void onCompleted() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.parent.combine(null, this.index);
        }

        public void requestMore(long n) {
            this.request(n);
        }
    }

    static final class LatestCoordinator<T, R>
    extends AtomicInteger
    implements Producer,
    Subscription {
        private static final long serialVersionUID = 8567835998786448817L;
        final Subscriber<? super R> actual;
        final FuncN<? extends R> combiner;
        final CombinerSubscriber<T, R>[] subscribers;
        final int bufferSize;
        final Object[] latest;
        final SpscLinkedArrayQueue<Object> queue;
        final boolean delayError;
        volatile boolean cancelled;
        volatile boolean done;
        final AtomicLong requested;
        final AtomicReference<Throwable> error;
        int active;
        int complete;
        static final Object MISSING = new Object();

        public LatestCoordinator(Subscriber<? super R> actual, FuncN<? extends R> combiner, int count2, int bufferSize, boolean delayError) {
            this.actual = actual;
            this.combiner = combiner;
            this.bufferSize = bufferSize;
            this.delayError = delayError;
            this.latest = new Object[count2];
            Arrays.fill(this.latest, MISSING);
            this.subscribers = new CombinerSubscriber[count2];
            this.queue = new SpscLinkedArrayQueue(bufferSize);
            this.requested = new AtomicLong();
            this.error = new AtomicReference();
        }

        public void subscribe(Observable<? extends T>[] sources) {
            int i;
            CombinerSubscriber<T, R>[] as = this.subscribers;
            int len = as.length;
            for (i = 0; i < len; ++i) {
                as[i] = new CombinerSubscriber(this, i);
            }
            this.lazySet(0);
            this.actual.add(this);
            this.actual.setProducer(this);
            for (i = 0; i < len; ++i) {
                if (this.cancelled) {
                    return;
                }
                sources[i].subscribe(as[i]);
            }
        }

        @Override
        public void request(long n) {
            if (n < 0L) {
                throw new IllegalArgumentException("n >= required but it was " + n);
            }
            if (n != 0L) {
                BackpressureUtils.getAndAddRequest(this.requested, n);
                this.drain();
            }
        }

        @Override
        public void unsubscribe() {
            if (!this.cancelled) {
                this.cancelled = true;
                if (this.getAndIncrement() == 0) {
                    this.cancel(this.queue);
                }
            }
        }

        @Override
        public boolean isUnsubscribed() {
            return this.cancelled;
        }

        void cancel(Queue<?> q) {
            q.clear();
            for (CombinerSubscriber<T, R> s2 : this.subscribers) {
                s2.unsubscribe();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void combine(Object value, int index2) {
            boolean allSourcesFinished;
            CombinerSubscriber<T, R> combinerSubscriber = this.subscribers[index2];
            LatestCoordinator latestCoordinator = this;
            synchronized (latestCoordinator) {
                boolean empty2;
                int sourceCount = this.latest.length;
                Object o = this.latest[index2];
                int activeCount = this.active;
                if (o == MISSING) {
                    this.active = ++activeCount;
                }
                int completedCount = this.complete;
                if (value == null) {
                    this.complete = ++completedCount;
                } else {
                    this.latest[index2] = NotificationLite.getValue(value);
                }
                allSourcesFinished = activeCount == sourceCount;
                boolean bl = empty2 = completedCount == sourceCount || value == null && o == MISSING;
                if (!empty2) {
                    if (value != null && allSourcesFinished) {
                        this.queue.offer(combinerSubscriber, this.latest.clone());
                    } else if (!(value != null || this.error.get() == null || o != MISSING && this.delayError)) {
                        this.done = true;
                    }
                } else {
                    this.done = true;
                }
            }
            if (!allSourcesFinished && value != null) {
                combinerSubscriber.requestMore(1L);
                return;
            }
            this.drain();
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            SpscLinkedArrayQueue<Object> q = this.queue;
            Subscriber<R> a = this.actual;
            boolean delayError = this.delayError;
            AtomicLong localRequested = this.requested;
            int missed = 1;
            do {
                long emitted;
                if (this.checkTerminated(this.done, q.isEmpty(), a, q, delayError)) {
                    return;
                }
                long requestAmount = localRequested.get();
                for (emitted = 0L; emitted != requestAmount; ++emitted) {
                    R v;
                    boolean empty2;
                    boolean d = this.done;
                    CombinerSubscriber cs = (CombinerSubscriber)q.peek();
                    boolean bl = empty2 = cs == null;
                    if (this.checkTerminated(d, empty2, a, q, delayError)) {
                        return;
                    }
                    if (empty2) break;
                    q.poll();
                    Object[] array2 = (Object[])q.poll();
                    if (array2 == null) {
                        this.cancelled = true;
                        this.cancel(q);
                        a.onError(new IllegalStateException("Broken queue?! Sender received but not the array."));
                        return;
                    }
                    try {
                        v = this.combiner.call(array2);
                    }
                    catch (Throwable ex) {
                        this.cancelled = true;
                        this.cancel(q);
                        a.onError(ex);
                        return;
                    }
                    a.onNext(v);
                    cs.requestMore(1L);
                }
                if (emitted == 0L || requestAmount == Long.MAX_VALUE) continue;
                BackpressureUtils.produced(localRequested, emitted);
            } while ((missed = this.addAndGet(-missed)) != 0);
        }

        boolean checkTerminated(boolean mainDone, boolean queueEmpty, Subscriber<?> childSubscriber, Queue<?> q, boolean delayError) {
            if (this.cancelled) {
                this.cancel(q);
                return true;
            }
            if (mainDone) {
                if (delayError) {
                    if (queueEmpty) {
                        Throwable e2 = this.error.get();
                        if (e2 != null) {
                            childSubscriber.onError(e2);
                        } else {
                            childSubscriber.onCompleted();
                        }
                        return true;
                    }
                } else {
                    Throwable e3 = this.error.get();
                    if (e3 != null) {
                        this.cancel(q);
                        childSubscriber.onError(e3);
                        return true;
                    }
                    if (queueEmpty) {
                        childSubscriber.onCompleted();
                        return true;
                    }
                }
            }
            return false;
        }

        void onError(Throwable e2) {
            Throwable next2;
            Throwable curr;
            AtomicReference<Throwable> localError = this.error;
            do {
                if ((curr = localError.get()) != null) {
                    if (curr instanceof CompositeException) {
                        CompositeException ce = (CompositeException)curr;
                        ArrayList<Throwable> es = new ArrayList<Throwable>(ce.getExceptions());
                        es.add(e2);
                        next2 = new CompositeException(es);
                        continue;
                    }
                    next2 = new CompositeException(Arrays.asList(curr, e2));
                    continue;
                }
                next2 = e2;
            } while (!localError.compareAndSet(curr, next2));
        }
    }
}

