/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.AbstractQueue;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import rx.Completable;
import rx.CompletableSubscriber;
import rx.Subscription;
import rx.internal.operators.CompletableOnSubscribeMerge;
import rx.internal.util.atomic.MpscLinkedAtomicQueue;
import rx.internal.util.unsafe.MpscLinkedQueue;
import rx.internal.util.unsafe.UnsafeAccess;
import rx.subscriptions.CompositeSubscription;

public final class CompletableOnSubscribeMergeDelayErrorIterable
implements Completable.OnSubscribe {
    final Iterable<? extends Completable> sources;

    public CompletableOnSubscribeMergeDelayErrorIterable(Iterable<? extends Completable> sources) {
        this.sources = sources;
    }

    @Override
    public void call(final CompletableSubscriber s2) {
        Iterator<? extends Completable> iterator2;
        final CompositeSubscription set2 = new CompositeSubscription();
        s2.onSubscribe(set2);
        try {
            iterator2 = this.sources.iterator();
        }
        catch (Throwable e2) {
            s2.onError(e2);
            return;
        }
        if (iterator2 == null) {
            s2.onError(new NullPointerException("The source iterator returned is null"));
            return;
        }
        final AtomicInteger wip = new AtomicInteger(1);
        final AbstractQueue queue2 = UnsafeAccess.isUnsafeAvailable() ? new MpscLinkedQueue() : new MpscLinkedAtomicQueue();
        while (true) {
            Completable c;
            boolean b;
            if (set2.isUnsubscribed()) {
                return;
            }
            try {
                b = iterator2.hasNext();
            }
            catch (Throwable e3) {
                queue2.offer(e3);
                if (wip.decrementAndGet() == 0) {
                    if (queue2.isEmpty()) {
                        s2.onCompleted();
                    } else {
                        s2.onError(CompletableOnSubscribeMerge.collectErrors(queue2));
                    }
                }
                return;
            }
            if (!b) break;
            if (set2.isUnsubscribed()) {
                return;
            }
            try {
                c = iterator2.next();
            }
            catch (Throwable e4) {
                queue2.offer(e4);
                if (wip.decrementAndGet() == 0) {
                    if (queue2.isEmpty()) {
                        s2.onCompleted();
                    } else {
                        s2.onError(CompletableOnSubscribeMerge.collectErrors(queue2));
                    }
                }
                return;
            }
            if (set2.isUnsubscribed()) {
                return;
            }
            if (c == null) {
                NullPointerException e5 = new NullPointerException("A completable source is null");
                queue2.offer(e5);
                if (wip.decrementAndGet() == 0) {
                    if (queue2.isEmpty()) {
                        s2.onCompleted();
                    } else {
                        s2.onError(CompletableOnSubscribeMerge.collectErrors(queue2));
                    }
                }
                return;
            }
            wip.getAndIncrement();
            c.unsafeSubscribe(new CompletableSubscriber(){

                @Override
                public void onSubscribe(Subscription d) {
                    set2.add(d);
                }

                @Override
                public void onError(Throwable e2) {
                    queue2.offer(e2);
                    this.tryTerminate();
                }

                @Override
                public void onCompleted() {
                    this.tryTerminate();
                }

                void tryTerminate() {
                    if (wip.decrementAndGet() == 0) {
                        if (queue2.isEmpty()) {
                            s2.onCompleted();
                        } else {
                            s2.onError(CompletableOnSubscribeMerge.collectErrors(queue2));
                        }
                    }
                }
            });
        }
        if (wip.decrementAndGet() == 0) {
            if (queue2.isEmpty()) {
                s2.onCompleted();
            } else {
                s2.onError(CompletableOnSubscribeMerge.collectErrors(queue2));
            }
        }
    }
}

