/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import rx.Completable;
import rx.CompletableSubscriber;
import rx.Observable;
import rx.Subscriber;
import rx.Subscription;
import rx.exceptions.MissingBackpressureException;
import rx.internal.subscriptions.SequentialSubscription;
import rx.internal.util.unsafe.SpscArrayQueue;
import rx.plugins.RxJavaHooks;

public final class CompletableOnSubscribeConcat
implements Completable.OnSubscribe {
    final Observable<Completable> sources;
    final int prefetch;

    public CompletableOnSubscribeConcat(Observable<? extends Completable> sources, int prefetch) {
        this.sources = sources;
        this.prefetch = prefetch;
    }

    @Override
    public void call(CompletableSubscriber s2) {
        CompletableConcatSubscriber parent = new CompletableConcatSubscriber(s2, this.prefetch);
        s2.onSubscribe(parent);
        this.sources.unsafeSubscribe(parent);
    }

    static final class CompletableConcatSubscriber
    extends Subscriber<Completable> {
        final CompletableSubscriber actual;
        final SequentialSubscription sr;
        final SpscArrayQueue<Completable> queue;
        final ConcatInnerSubscriber inner;
        final AtomicBoolean once;
        volatile boolean done;
        volatile boolean active;

        public CompletableConcatSubscriber(CompletableSubscriber actual, int prefetch) {
            this.actual = actual;
            this.queue = new SpscArrayQueue(prefetch);
            this.sr = new SequentialSubscription();
            this.inner = new ConcatInnerSubscriber();
            this.once = new AtomicBoolean();
            this.add(this.sr);
            this.request(prefetch);
        }

        @Override
        public void onNext(Completable t3) {
            if (!this.queue.offer(t3)) {
                this.onError(new MissingBackpressureException());
                return;
            }
            this.drain();
        }

        @Override
        public void onError(Throwable t3) {
            if (this.once.compareAndSet(false, true)) {
                this.actual.onError(t3);
                return;
            }
            RxJavaHooks.onError(t3);
        }

        @Override
        public void onCompleted() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.drain();
        }

        void innerError(Throwable e2) {
            this.unsubscribe();
            this.onError(e2);
        }

        void innerComplete() {
            this.active = false;
            this.drain();
        }

        void drain() {
            ConcatInnerSubscriber inner = this.inner;
            if (inner.getAndIncrement() != 0) {
                return;
            }
            do {
                boolean empty2;
                if (this.isUnsubscribed()) {
                    return;
                }
                if (this.active) continue;
                boolean d = this.done;
                Completable c = this.queue.poll();
                boolean bl = empty2 = c == null;
                if (d && empty2) {
                    this.actual.onCompleted();
                    return;
                }
                if (empty2) continue;
                this.active = true;
                c.subscribe(inner);
                this.request(1L);
            } while (inner.decrementAndGet() != 0);
        }

        final class ConcatInnerSubscriber
        extends AtomicInteger
        implements CompletableSubscriber {
            private static final long serialVersionUID = 7233503139645205620L;

            ConcatInnerSubscriber() {
            }

            @Override
            public void onSubscribe(Subscription d) {
                CompletableConcatSubscriber.this.sr.set(d);
            }

            @Override
            public void onError(Throwable e2) {
                CompletableConcatSubscriber.this.innerError(e2);
            }

            @Override
            public void onCompleted() {
                CompletableConcatSubscriber.this.innerComplete();
            }
        }
    }
}

