/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.concurrent.atomic.AtomicBoolean;
import rx.Completable;
import rx.CompletableEmitter;
import rx.CompletableSubscriber;
import rx.Subscription;
import rx.exceptions.Exceptions;
import rx.functions.Action1;
import rx.functions.Cancellable;
import rx.internal.subscriptions.CancellableSubscription;
import rx.internal.subscriptions.SequentialSubscription;
import rx.plugins.RxJavaHooks;

public final class CompletableFromEmitter
implements Completable.OnSubscribe {
    final Action1<CompletableEmitter> producer;

    public CompletableFromEmitter(Action1<CompletableEmitter> producer) {
        this.producer = producer;
    }

    @Override
    public void call(CompletableSubscriber t3) {
        FromEmitter emitter = new FromEmitter(t3);
        t3.onSubscribe(emitter);
        try {
            this.producer.call(emitter);
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal(ex);
            emitter.onError(ex);
        }
    }

    static final class FromEmitter
    extends AtomicBoolean
    implements CompletableEmitter,
    Subscription {
        private static final long serialVersionUID = 5539301318568668881L;
        final CompletableSubscriber actual;
        final SequentialSubscription resource;

        public FromEmitter(CompletableSubscriber actual) {
            this.actual = actual;
            this.resource = new SequentialSubscription();
        }

        @Override
        public void onCompleted() {
            if (this.compareAndSet(false, true)) {
                try {
                    this.actual.onCompleted();
                }
                finally {
                    this.resource.unsubscribe();
                }
            }
        }

        @Override
        public void onError(Throwable t3) {
            if (this.compareAndSet(false, true)) {
                try {
                    this.actual.onError(t3);
                }
                finally {
                    this.resource.unsubscribe();
                }
            } else {
                RxJavaHooks.onError(t3);
            }
        }

        @Override
        public void setSubscription(Subscription s2) {
            this.resource.update(s2);
        }

        @Override
        public void setCancellation(Cancellable c) {
            this.setSubscription(new CancellableSubscription(c));
        }

        @Override
        public void unsubscribe() {
            if (this.compareAndSet(false, true)) {
                this.resource.unsubscribe();
            }
        }

        @Override
        public boolean isUnsubscribed() {
            return this.get();
        }
    }
}

