/*
 * Decompiled with CFR 0.152.
 */
package rx.exceptions;

import java.util.HashSet;
import java.util.List;
import rx.Observer;
import rx.SingleSubscriber;
import rx.exceptions.CompositeException;
import rx.exceptions.OnCompletedFailedException;
import rx.exceptions.OnErrorFailedException;
import rx.exceptions.OnErrorNotImplementedException;
import rx.exceptions.OnErrorThrowable;

public final class Exceptions {
    private static final int MAX_DEPTH = 25;

    private Exceptions() {
        throw new IllegalStateException("No instances!");
    }

    public static RuntimeException propagate(Throwable t3) {
        if (t3 instanceof RuntimeException) {
            throw (RuntimeException)t3;
        }
        if (t3 instanceof Error) {
            throw (Error)t3;
        }
        throw new RuntimeException(t3);
    }

    public static void throwIfFatal(Throwable t3) {
        if (t3 instanceof OnErrorNotImplementedException) {
            throw (OnErrorNotImplementedException)t3;
        }
        if (t3 instanceof OnErrorFailedException) {
            throw (OnErrorFailedException)t3;
        }
        if (t3 instanceof OnCompletedFailedException) {
            throw (OnCompletedFailedException)t3;
        }
        if (t3 instanceof VirtualMachineError) {
            throw (VirtualMachineError)t3;
        }
        if (t3 instanceof ThreadDeath) {
            throw (ThreadDeath)t3;
        }
        if (t3 instanceof LinkageError) {
            throw (LinkageError)t3;
        }
    }

    public static void addCause(Throwable e2, Throwable cause) {
        HashSet<Throwable> seenCauses = new HashSet<Throwable>();
        int i = 0;
        while (e2.getCause() != null) {
            if (i++ >= 25) {
                return;
            }
            if (seenCauses.contains((e2 = e2.getCause()).getCause())) break;
            seenCauses.add(e2.getCause());
        }
        try {
            e2.initCause(cause);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static Throwable getFinalCause(Throwable e2) {
        int i = 0;
        while (e2.getCause() != null) {
            if (i++ >= 25) {
                return new RuntimeException("Stack too deep to get final cause");
            }
            e2 = e2.getCause();
        }
        return e2;
    }

    public static void throwIfAny(List<? extends Throwable> exceptions) {
        if (exceptions != null && !exceptions.isEmpty()) {
            if (exceptions.size() == 1) {
                Throwable t3 = exceptions.get(0);
                if (t3 instanceof RuntimeException) {
                    throw (RuntimeException)t3;
                }
                if (t3 instanceof Error) {
                    throw (Error)t3;
                }
                throw new RuntimeException(t3);
            }
            throw new CompositeException(exceptions);
        }
    }

    public static void throwOrReport(Throwable t3, Observer<?> o, Object value) {
        Exceptions.throwIfFatal(t3);
        o.onError(OnErrorThrowable.addValueAsLastCause(t3, value));
    }

    public static void throwOrReport(Throwable t3, SingleSubscriber<?> o, Object value) {
        Exceptions.throwIfFatal(t3);
        o.onError(OnErrorThrowable.addValueAsLastCause(t3, value));
    }

    public static void throwOrReport(Throwable t3, Observer<?> o) {
        Exceptions.throwIfFatal(t3);
        o.onError(t3);
    }

    public static void throwOrReport(Throwable throwable, SingleSubscriber<?> subscriber) {
        Exceptions.throwIfFatal(throwable);
        subscriber.onError(throwable);
    }
}

