/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.bridge;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.spi.LocationAwareLogger;

public class SLF4JBridgeHandler
extends Handler {
    private static final String FQCN = java.util.logging.Logger.class.getName();
    private static final String UNKNOWN_LOGGER_NAME = "unknown.jul.logger";
    private static final int TRACE_LEVEL_THRESHOLD = Level.FINEST.intValue();
    private static final int DEBUG_LEVEL_THRESHOLD = Level.FINE.intValue();
    private static final int INFO_LEVEL_THRESHOLD = Level.INFO.intValue();
    private static final int WARN_LEVEL_THRESHOLD = Level.WARNING.intValue();

    public static void install() {
        LogManager.getLogManager().getLogger("").addHandler(new SLF4JBridgeHandler());
    }

    private static java.util.logging.Logger getRootLogger() {
        return LogManager.getLogManager().getLogger("");
    }

    public static void uninstall() throws SecurityException {
        Handler[] handlers;
        java.util.logging.Logger rootLogger = SLF4JBridgeHandler.getRootLogger();
        for (Handler handler : handlers = rootLogger.getHandlers()) {
            if (!(handler instanceof SLF4JBridgeHandler)) continue;
            rootLogger.removeHandler(handler);
        }
    }

    public static boolean isInstalled() {
        Handler[] handlers;
        java.util.logging.Logger rootLogger = SLF4JBridgeHandler.getRootLogger();
        for (Handler handler : handlers = rootLogger.getHandlers()) {
            if (!(handler instanceof SLF4JBridgeHandler)) continue;
            return true;
        }
        return false;
    }

    public static void removeHandlersForRootLogger() {
        Handler[] handlers;
        java.util.logging.Logger rootLogger = SLF4JBridgeHandler.getRootLogger();
        for (Handler handler : handlers = rootLogger.getHandlers()) {
            rootLogger.removeHandler(handler);
        }
    }

    @Override
    public void close() {
    }

    @Override
    public void flush() {
    }

    protected Logger getSLF4JLogger(LogRecord record2) {
        String name2 = record2.getLoggerName();
        if (name2 == null) {
            name2 = UNKNOWN_LOGGER_NAME;
        }
        return LoggerFactory.getLogger(name2);
    }

    protected void callLocationAwareLogger(LocationAwareLogger lal, LogRecord record2) {
        int julLevelValue = record2.getLevel().intValue();
        int slf4jLevel = julLevelValue <= TRACE_LEVEL_THRESHOLD ? 0 : (julLevelValue <= DEBUG_LEVEL_THRESHOLD ? 10 : (julLevelValue <= INFO_LEVEL_THRESHOLD ? 20 : (julLevelValue <= WARN_LEVEL_THRESHOLD ? 30 : 40)));
        String i18nMessage = this.getMessageI18N(record2);
        lal.log(null, FQCN, slf4jLevel, i18nMessage, null, record2.getThrown());
    }

    protected void callPlainSLF4JLogger(Logger slf4jLogger, LogRecord record2) {
        String i18nMessage = this.getMessageI18N(record2);
        int julLevelValue = record2.getLevel().intValue();
        if (julLevelValue <= TRACE_LEVEL_THRESHOLD) {
            slf4jLogger.trace(i18nMessage, record2.getThrown());
        } else if (julLevelValue <= DEBUG_LEVEL_THRESHOLD) {
            slf4jLogger.debug(i18nMessage, record2.getThrown());
        } else if (julLevelValue <= INFO_LEVEL_THRESHOLD) {
            slf4jLogger.info(i18nMessage, record2.getThrown());
        } else if (julLevelValue <= WARN_LEVEL_THRESHOLD) {
            slf4jLogger.warn(i18nMessage, record2.getThrown());
        } else {
            slf4jLogger.error(i18nMessage, record2.getThrown());
        }
    }

    private String getMessageI18N(LogRecord record2) {
        Object[] params;
        String message = record2.getMessage();
        if (message == null) {
            return null;
        }
        ResourceBundle bundle = record2.getResourceBundle();
        if (bundle != null) {
            try {
                message = bundle.getString(message);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        if ((params = record2.getParameters()) != null && params.length > 0) {
            try {
                message = MessageFormat.format(message, params);
            }
            catch (IllegalArgumentException e2) {
                return message;
            }
        }
        return message;
    }

    @Override
    public void publish(LogRecord record2) {
        if (record2 == null) {
            return;
        }
        Logger slf4jLogger = this.getSLF4JLogger(record2);
        if (record2.getMessage() == null) {
            record2.setMessage("");
        }
        if (slf4jLogger instanceof LocationAwareLogger) {
            this.callLocationAwareLogger((LocationAwareLogger)slf4jLogger, record2);
        } else {
            this.callPlainSLF4JLogger(slf4jLogger, record2);
        }
    }
}

