/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.vertx.handler.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.ext.auth.User;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.impl.AuthenticationHandlerImpl;
import org.pac4j.core.config.Config;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.engine.DefaultSecurityLogic;
import org.pac4j.core.engine.SecurityLogic;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.http.adapter.HttpActionAdapter;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.core.util.FindBest;
import org.pac4j.vertx.VertxProfileManager;
import org.pac4j.vertx.VertxWebContext;
import org.pac4j.vertx.auth.Pac4jAuthProvider;
import org.pac4j.vertx.context.session.VertxSessionStore;
import org.pac4j.vertx.handler.impl.SecurityHandlerOptions;
import org.pac4j.vertx.http.VertxHttpActionAdapter;

public class SecurityHandler
extends AuthenticationHandlerImpl {
    private static final Logger LOG = LoggerFactory.getLogger(SecurityHandler.class);
    protected final Config config;
    protected final String clientNames;
    protected final String authorizerName;
    protected final String matcherName;
    protected final boolean multiProfile;
    protected final Vertx vertx;
    private final SessionStore sessionStore;

    public SecurityHandler(Vertx vertx, SessionStore sessionStore, Config config, Pac4jAuthProvider authProvider, SecurityHandlerOptions options2) {
        super(authProvider);
        CommonHelper.assertNotNull("vertx", vertx);
        CommonHelper.assertNotNull("sessionStore", sessionStore);
        CommonHelper.assertNotNull("config", config);
        CommonHelper.assertNotNull("config.getClients()", config.getClients());
        CommonHelper.assertNotNull("authProvider", authProvider);
        CommonHelper.assertNotNull("options", options2);
        this.clientNames = options2.getClients();
        this.authorizerName = options2.getAuthorizers();
        this.matcherName = options2.getMatchers();
        this.multiProfile = options2.isMultiProfile();
        this.vertx = vertx;
        this.sessionStore = sessionStore;
        this.config = config;
    }

    @Override
    public void authenticate(RoutingContext routingContext, Handler<AsyncResult<User>> handler) {
        SecurityLogic bestLogic = FindBest.securityLogic(null, this.config, DefaultSecurityLogic.INSTANCE);
        HttpActionAdapter bestAdapter = FindBest.httpActionAdapter(null, this.config, VertxHttpActionAdapter.INSTANCE);
        VertxWebContext webContext = new VertxWebContext(routingContext, this.sessionStore);
        this.vertx.executeBlocking(future2 -> bestLogic.perform(webContext, this.sessionStore, this.config, (ctx, store, profiles, parameters2) -> {
            future2.complete();
            return null;
        }, bestAdapter, this.clientNames, this.authorizerName, this.matcherName, new Object[0]), asyncResult -> {
            if (asyncResult.failed()) {
                this.unexpectedFailure(routingContext, asyncResult.cause());
            } else {
                LOG.info("Authorised to view resource " + routingContext.request().path());
                routingContext.next();
            }
        });
    }

    protected void unexpectedFailure(RoutingContext context, Throwable failure) {
        context.fail(this.toTechnicalException(failure));
    }

    protected final TechnicalException toTechnicalException(Throwable t3) {
        return t3 instanceof TechnicalException ? (TechnicalException)t3 : new TechnicalException(t3);
    }

    static {
        Config.defaultProfileManagerFactory("VertxProfileManager", (ctx, store) -> new VertxProfileManager((VertxWebContext)ctx, (VertxSessionStore)store));
    }
}

