/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.vertx.handler.impl;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.ext.web.RoutingContext;
import org.pac4j.core.config.Config;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.engine.DefaultLogoutLogic;
import org.pac4j.core.engine.LogoutLogic;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.http.adapter.HttpActionAdapter;
import org.pac4j.core.util.FindBest;
import org.pac4j.vertx.VertxWebContext;
import org.pac4j.vertx.handler.impl.LogoutHandlerOptions;
import org.pac4j.vertx.http.VertxHttpActionAdapter;

public class LogoutHandler
implements Handler<RoutingContext> {
    protected final String defaultUrl;
    protected final String logoutUrlPattern;
    protected final Config config;
    private final Vertx vertx;
    private final SessionStore sessionStore;
    private final boolean localLogout;
    private final boolean destroySession;
    private final boolean centralLogout;

    public LogoutHandler(Vertx vertx, SessionStore sessionStore, LogoutHandlerOptions options2, Config config) {
        this.defaultUrl = options2.getDefaultUrl();
        this.logoutUrlPattern = options2.getLogoutUrlPattern();
        this.config = config;
        this.vertx = vertx;
        this.sessionStore = sessionStore;
        this.localLogout = options2.isLocalLogout();
        this.destroySession = options2.isDestroySession();
        this.centralLogout = options2.isCentralLogout();
    }

    @Override
    public void handle(RoutingContext routingContext) {
        LogoutLogic bestLogic = FindBest.logoutLogic(null, this.config, DefaultLogoutLogic.INSTANCE);
        HttpActionAdapter bestAdapter = FindBest.httpActionAdapter(null, this.config, VertxHttpActionAdapter.INSTANCE);
        VertxWebContext webContext = new VertxWebContext(routingContext, this.sessionStore);
        this.vertx.executeBlocking(future2 -> {
            bestLogic.perform(webContext, this.sessionStore, this.config, bestAdapter, this.defaultUrl, this.logoutUrlPattern, this.localLogout, this.destroySession, this.centralLogout);
            future2.complete(null);
        }, false, asyncResult -> {
            if (asyncResult.failed()) {
                routingContext.fail(new TechnicalException(asyncResult.cause()));
            }
        });
    }
}

