/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.vertx.handler.impl;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.ext.web.RoutingContext;
import org.pac4j.core.config.Config;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.engine.CallbackLogic;
import org.pac4j.core.engine.DefaultCallbackLogic;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.http.adapter.HttpActionAdapter;
import org.pac4j.core.util.FindBest;
import org.pac4j.vertx.VertxWebContext;
import org.pac4j.vertx.handler.impl.CallbackHandlerOptions;
import org.pac4j.vertx.http.VertxHttpActionAdapter;

public class CallbackHandler
implements Handler<RoutingContext> {
    protected static final Logger LOG = LoggerFactory.getLogger(CallbackHandler.class);
    private final Vertx vertx;
    private final SessionStore sessionStore;
    private final Config config;
    private final String defaultUrl;
    private final Boolean renewSession;
    private final String defaultClient;

    public CallbackHandler(Vertx vertx, SessionStore sessionStore, Config config, CallbackHandlerOptions options2) {
        this.vertx = vertx;
        this.sessionStore = sessionStore;
        this.config = config;
        this.defaultUrl = options2.getDefaultUrl();
        this.renewSession = options2.getRenewSession();
        this.defaultClient = options2.getDefaultClient();
    }

    @Override
    public void handle(RoutingContext event) {
        CallbackLogic bestLogic = FindBest.callbackLogic(null, this.config, DefaultCallbackLogic.INSTANCE);
        HttpActionAdapter bestAdapter = FindBest.httpActionAdapter(null, this.config, VertxHttpActionAdapter.INSTANCE);
        VertxWebContext webContext = new VertxWebContext(event, this.sessionStore);
        this.vertx.executeBlocking(future2 -> {
            bestLogic.perform(webContext, this.sessionStore, this.config, bestAdapter, this.defaultUrl, this.renewSession, this.defaultClient);
            future2.complete(null);
        }, false, asyncResult -> {
            if (asyncResult.failed()) {
                event.fail(new TechnicalException(asyncResult.cause()));
            }
        });
    }
}

