/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.vertx.core.store;

import io.vertx.core.Vertx;
import io.vertx.rxjava.core.shareddata.AsyncMap;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.store.Store;
import org.pac4j.vertx.core.store.VertxMapStoreBase;
import rx.Single;
import rx.functions.Func1;

public class VertxClusteredMapStore<K, V>
extends VertxMapStoreBase
implements Store<K, V> {
    private final io.vertx.rxjava.core.Vertx rxVertx;
    private final int blockingTimeoutSeconds;

    public VertxClusteredMapStore(Vertx vertx) {
        this(vertx, 1);
    }

    public VertxClusteredMapStore(Vertx vertx, int timeoutSeconds) {
        this.rxVertx = io.vertx.rxjava.core.Vertx.newInstance(vertx);
        this.blockingTimeoutSeconds = timeoutSeconds;
    }

    @Override
    public Optional<V> get(K key2) {
        this.voidAsyncOpToBlocking(map2 -> map2.rxGet(key2));
        CompletableFuture valueFuture = new CompletableFuture();
        this.rxVertx.sharedData().rxGetClusterWideMap("pac4jSharedData").flatMap(map2 -> map2.rxGet(key2)).subscribe(valueFuture::complete);
        try {
            return Optional.ofNullable(valueFuture.get(this.blockingTimeoutSeconds, TimeUnit.SECONDS));
        }
        catch (InterruptedException | ExecutionException | TimeoutException e2) {
            throw new TechnicalException(e2);
        }
    }

    @Override
    public void set(K key2, V value) {
        this.voidAsyncOpToBlocking(map2 -> map2.rxPut(key2, value));
    }

    @Override
    public void remove(K key2) {
        this.voidAsyncOpToBlocking(map2 -> map2.rxRemove(key2));
    }

    public void voidAsyncOpToBlocking(Func1<AsyncMap, Single> asyncOp) {
        CompletableFuture future2 = new CompletableFuture();
        this.rxVertx.sharedData().rxGetAsyncMap("pac4jSharedData").map(asyncOp).subscribe(result2 -> future2.complete(null));
        try {
            future2.get(this.blockingTimeoutSeconds, TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e2) {
            throw new TechnicalException(e2);
        }
    }
}

