/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.vertx.core;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.scribejava.core.model.OAuth1RequestToken;
import com.github.scribejava.core.model.Token;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.token.AccessTokenType;
import com.nimbusds.oauth2.sdk.token.BearerAccessToken;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.vertx.core.JsonConverter;

public class DefaultJsonConverter
implements JsonConverter {
    private final ObjectMapper mapper = new ObjectMapper();
    private static final DefaultJsonConverter INSTANCE = new DefaultJsonConverter();

    public static JsonConverter getInstance() {
        return INSTANCE;
    }

    public DefaultJsonConverter() {
        this.mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        this.mapper.setVisibility(PropertyAccessor.GETTER, JsonAutoDetect.Visibility.NONE);
        this.mapper.setVisibility(PropertyAccessor.IS_GETTER, JsonAutoDetect.Visibility.NONE);
        this.mapper.addMixIn(OAuth1RequestToken.class, OAuth1RequestTokenMixin.class).addMixIn(BearerAccessToken.class, BearerAccessTokenMixin.class).addMixIn(Scope.Value.class, ValueMixin.class).addMixIn(Token.class, TokenMixin.class);
    }

    @Override
    public Object encodeObject(Object value) {
        if (value == null) {
            return null;
        }
        if (this.isPrimitiveType(value)) {
            return value;
        }
        if (value instanceof Object[]) {
            Object[] src = (Object[])value;
            ArrayList<Object> list = new ArrayList<Object>(src.length);
            this.fillEncodedList(src, list);
            return new JsonArray(list);
        }
        try {
            return new JsonObject().put("class", value.getClass().getName()).put("value", new JsonObject(this.encode(value)));
        }
        catch (Exception e2) {
            throw new TechnicalException("Error while encoding object", e2);
        }
    }

    private void fillEncodedList(Object[] src, List<Object> list) {
        for (Object object : src) {
            list.add(this.encodeObject(object));
        }
    }

    @Override
    public Object decodeObject(Object value) {
        if (value == null) {
            return null;
        }
        if (this.isPrimitiveType(value)) {
            return value;
        }
        if (value instanceof JsonArray) {
            JsonArray src = (JsonArray)value;
            ArrayList<Object> list = new ArrayList<Object>(src.size());
            this.fillDecodedList(src, list);
            return list.toArray();
        }
        if (value instanceof JsonObject) {
            JsonObject src = (JsonObject)value;
            return this.decode(src);
        }
        return null;
    }

    private Object decode(JsonObject src) {
        try {
            return this.decode(src.getJsonObject("value").encode(), Class.forName(src.getString("class")));
        }
        catch (Exception e2) {
            throw new TechnicalException("Error while decoding object", e2);
        }
    }

    private void fillDecodedList(JsonArray src, List<Object> list) {
        for (Object object : src) {
            list.add(this.decodeObject(object));
        }
    }

    private boolean isPrimitiveType(Object value) {
        return value instanceof String || value instanceof Number || value instanceof Boolean;
    }

    private String encode(Object value) throws JsonGenerationException, JsonMappingException, IOException {
        return this.mapper.writeValueAsString(value);
    }

    private <T> T decode(String string2, Class<?> clazz) throws JsonParseException, JsonMappingException, IOException {
        return (T)this.mapper.readValue(string2, clazz);
    }

    public static class OAuth1RequestTokenMixin {
        @JsonCreator
        public OAuth1RequestTokenMixin(@JsonProperty(value="token") String token2, @JsonProperty(value="tokenSecret") String tokenSecret, @JsonProperty(value="oauthCallbackConfirmed") boolean oauthCallbackConfirmed, @JsonProperty(value="rawResponse") String RawResponse) {
        }
    }

    public static class TokenMixin {
        @JsonCreator
        public TokenMixin(@JsonProperty(value="token") String token2, @JsonProperty(value="secret") String secret, @JsonProperty(value="rawResponse") String rawResponse) {
        }
    }

    public static class ValueMixin {
        @JsonCreator
        public ValueMixin(@JsonProperty(value="value") String value, @JsonProperty(value="requirement") Scope.Value.Requirement requirement) {
        }
    }

    public static class BearerAccessTokenMixin {
        @JsonIgnore
        private AccessTokenType type;

        @JsonCreator
        public BearerAccessTokenMixin(@JsonProperty(value="value") String value, @JsonProperty(value="lifetime") long lifetime, @JsonProperty(value="scope") Scope scope2) {
        }
    }
}

