/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.vertx.auth;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonObject;
import io.vertx.core.shareddata.impl.ClusterSerializable;
import io.vertx.ext.auth.AuthProvider;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.authorization.Authorization;
import io.vertx.ext.auth.impl.UserImpl;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.pac4j.core.profile.UserProfile;

public class Pac4jUser
extends UserImpl
implements User,
ClusterSerializable {
    private final Map<String, UserProfile> profiles = new LinkedHashMap<String, UserProfile>();
    private JsonObject principal;

    @Override
    public JsonObject attributes() {
        return null;
    }

    @Override
    public User isAuthorized(Authorization authorization, Handler<AsyncResult<Boolean>> resultHandler) {
        resultHandler.handle(Future.succeededFuture(this.profiles.values().stream().anyMatch(p -> p.getRoles().contains(authorization))));
        return this;
    }

    @Override
    public JsonObject principal() {
        return this.principal;
    }

    @Override
    public void setAuthProvider(AuthProvider authProvider) {
    }

    public void setUserProfiles(Map<String, UserProfile> userProfiles) {
        Objects.requireNonNull(userProfiles);
        this.profiles.clear();
        this.profiles.putAll(userProfiles);
        this.updatePrincipal();
    }

    private void updatePrincipal() {
        this.principal = new JsonObject();
        this.profiles.forEach((name2, profile) -> {
            JsonObject jsonProfile = new JsonObject();
            profile.getAttributes().forEach((attributeName, attributeValue) -> jsonProfile.put((String)attributeName, attributeValue.toString()));
            this.principal.put((String)name2, jsonProfile);
        });
    }
}

