/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.vertx;

import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.Session;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.InvalidParameterException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.pac4j.core.context.Cookie;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.vertx.auth.Pac4jUser;

public class VertxWebContext
implements WebContext {
    private final RoutingContext routingContext;
    private final String method;
    private final String serverName;
    private final int serverPort;
    private final String fullUrl;
    private final String scheme;
    private final String remoteAddress;
    private final JsonObject headers;
    private final JsonObject parameters;
    private final Map<String, String[]> mapParameters;
    private final SessionStore sessionStore;

    public VertxWebContext(RoutingContext routingContext, SessionStore sessionStore) {
        URI uri;
        HttpServerRequest request = routingContext.request();
        this.routingContext = routingContext;
        this.method = request.method().toString();
        this.sessionStore = sessionStore;
        this.fullUrl = request.absoluteURI();
        try {
            uri = new URI(this.fullUrl);
        }
        catch (URISyntaxException e2) {
            e2.printStackTrace();
            throw new InvalidParameterException("Request to invalid URL " + this.fullUrl + " while constructing VertxWebContext");
        }
        this.scheme = uri.getScheme();
        this.serverName = uri.getHost();
        this.serverPort = uri.getPort() != -1 ? uri.getPort() : (this.scheme.equals("http") ? 80 : 443);
        this.remoteAddress = request.remoteAddress().toString();
        this.headers = new JsonObject();
        for (String name2 : request.headers().names()) {
            this.headers.put(name2, request.headers().get(name2));
        }
        this.parameters = new JsonObject();
        for (String name2 : request.params().names()) {
            this.parameters.put(name2, new JsonArray(Arrays.asList(request.params().getAll(name2).toArray())));
        }
        for (String name2 : request.formAttributes().names()) {
            this.parameters.put(name2, new JsonArray(Arrays.asList(request.formAttributes().getAll(name2).toArray())));
        }
        this.mapParameters = new HashMap<String, String[]>();
        for (String name2 : this.parameters.fieldNames()) {
            JsonArray params = this.parameters.getJsonArray(name2);
            String[] values2 = new String[params.size()];
            int i = 0;
            for (Object o : params) {
                values2[i++] = (String)o;
            }
            this.mapParameters.put(name2, values2);
        }
    }

    @Override
    public Optional<String> getRequestParameter(String name2) {
        JsonArray values2 = this.parameters.getJsonArray(name2);
        if (values2 != null && values2.size() > 0) {
            return Optional.ofNullable(values2.getString(0));
        }
        return Optional.empty();
    }

    @Override
    public Map<String, String[]> getRequestParameters() {
        return this.mapParameters;
    }

    @Override
    public Optional<Object> getRequestAttribute(String s2) {
        return Optional.ofNullable(this.routingContext.get(s2));
    }

    @Override
    public void setRequestAttribute(String s2, Object o) {
        this.routingContext.put(s2, o);
    }

    @Override
    public Optional<String> getRequestHeader(String name2) {
        return Optional.ofNullable(this.headers.getString(name2));
    }

    @Override
    public String getRequestMethod() {
        return this.method;
    }

    @Override
    public String getRemoteAddr() {
        return this.remoteAddress;
    }

    @Override
    public void setResponseHeader(String name2, String value) {
        this.routingContext.response().putHeader(name2, value);
    }

    @Override
    public Optional<String> getResponseHeader(String s2) {
        return Optional.ofNullable(this.routingContext.response().headers().get(s2));
    }

    public Map<String, String> getResponseHeaders() {
        return this.routingContext.response().headers().entries().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @Override
    public void setResponseContentType(String s2) {
        this.routingContext.response().headers().add("Content-Type", s2);
    }

    @Override
    public String getServerName() {
        return this.serverName;
    }

    @Override
    public int getServerPort() {
        return this.serverPort;
    }

    @Override
    public String getScheme() {
        return this.scheme;
    }

    @Override
    public boolean isSecure() {
        return this.getScheme().equals("https");
    }

    @Override
    public String getFullRequestURL() {
        return this.fullUrl;
    }

    @Override
    public Collection<Cookie> getRequestCookies() {
        return this.routingContext.cookieMap().values().stream().map(cookie -> {
            io.vertx.core.http.Cookie cookie1 = cookie;
            Cookie p4jCookie = new Cookie(cookie.getName(), cookie.getValue());
            p4jCookie.setDomain(cookie.getDomain());
            p4jCookie.setPath(cookie.getPath());
            return p4jCookie;
        }).collect(Collectors.toList());
    }

    @Override
    public void addResponseCookie(Cookie cookie) {
        io.vertx.core.http.Cookie vertxCookie = io.vertx.core.http.Cookie.cookie(cookie.getName(), cookie.getValue()).setHttpOnly(cookie.isHttpOnly()).setSecure(cookie.isSecure()).setDomain(cookie.getDomain()).setPath(cookie.getPath());
        if (cookie.getMaxAge() > 0) {
            vertxCookie.setMaxAge(cookie.getMaxAge());
        }
        this.routingContext.addCookie(vertxCookie);
    }

    @Override
    public String getPath() {
        return this.routingContext.request().path();
    }

    public Pac4jUser getVertxUser() {
        return (Pac4jUser)this.routingContext.user();
    }

    public void removeVertxUser() {
        this.routingContext.clearUser();
    }

    public void setVertxUser(Pac4jUser pac4jUser) {
        this.routingContext.setUser(pac4jUser);
    }

    public Session getVertxSession() {
        return this.routingContext.session();
    }

    public RoutingContext getVertxRoutingContext() {
        return this.routingContext;
    }
}

