/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.authorization.generator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import org.pac4j.core.authorization.generator.AuthorizationGenerator;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.core.util.CommonHelper;

public class SpringSecurityPropertiesAuthorizationGenerator
implements AuthorizationGenerator {
    public static final String DISABLED = "disabled";
    public static final String ENABLED = "enabled";
    private Map<String, List<String>> rolesByUsers = new HashMap<String, List<String>>();

    public SpringSecurityPropertiesAuthorizationGenerator(Properties properties2) {
        Set<String> keys2 = properties2.stringPropertyNames();
        for (String key2 : keys2) {
            String latest2;
            String[] parts;
            int nb;
            String value = properties2.getProperty(key2);
            if (!CommonHelper.isNotBlank(value) || (nb = (parts = value.split(",")).length) <= 1 || DISABLED.equals(latest2 = parts[nb - 1])) continue;
            ArrayList<String> roles = new ArrayList<String>(Arrays.asList(parts));
            if (ENABLED.equals(latest2)) {
                roles.remove(nb - 1);
            }
            roles.remove(0);
            this.rolesByUsers.put(key2, roles);
        }
    }

    @Override
    public Optional<UserProfile> generate(WebContext context, SessionStore sessionStore, UserProfile profile) {
        String id = profile.getId();
        List<String> roles = this.rolesByUsers.get(id);
        if (roles != null && !roles.isEmpty()) {
            profile.addRoles(roles);
        }
        return Optional.of(profile);
    }
}

