/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.cas.credentials.extractor;

import java.util.Base64;
import java.util.Optional;
import java.util.zip.Inflater;
import org.jasig.cas.client.Protocol;
import org.pac4j.cas.config.CasConfiguration;
import org.pac4j.cas.config.CasProtocol;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.WebContextHelper;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.credentials.TokenCredentials;
import org.pac4j.core.credentials.extractor.CredentialsExtractor;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.exception.http.NoContentAction;
import org.pac4j.core.exception.http.OkAction;
import org.pac4j.core.logout.handler.LogoutHandler;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.core.util.HttpActionHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TicketAndLogoutRequestExtractor
implements CredentialsExtractor {
    private static final int DECOMPRESSION_FACTOR = 10;
    private static final Logger logger = LoggerFactory.getLogger(TicketAndLogoutRequestExtractor.class);
    protected CasConfiguration configuration;

    public TicketAndLogoutRequestExtractor(CasConfiguration configuration) {
        CommonHelper.assertNotNull("configuration", configuration);
        this.configuration = configuration;
    }

    @Override
    public Optional<Credentials> extract(WebContext context, SessionStore sessionStore) {
        LogoutHandler logoutHandler = this.configuration.findLogoutHandler();
        if (this.isTokenRequest(context)) {
            String ticket = this.getArtifactParameter(context).get();
            logoutHandler.recordSession(context, sessionStore, ticket);
            TokenCredentials casCredentials = new TokenCredentials(ticket);
            logger.debug("casCredentials: {}", (Object)casCredentials);
            return Optional.of(casCredentials);
        }
        if (this.isBackLogoutRequest(context)) {
            String logoutMessage = context.getRequestParameter("logoutRequest").get();
            logger.trace("Logout request:\n{}", (Object)logoutMessage);
            String ticket = CommonHelper.substringBetween(logoutMessage, "SessionIndex>", "</");
            if (CommonHelper.isNotBlank(ticket)) {
                logoutHandler.destroySessionBack(context, sessionStore, ticket);
            }
            logger.debug("back logout request: no credential returned");
            throw NoContentAction.INSTANCE;
        }
        if (this.isFrontLogoutRequest(context)) {
            String logoutMessage = this.uncompressLogoutMessage(context.getRequestParameter("logoutRequest").get());
            logger.trace("Logout request:\n{}", (Object)logoutMessage);
            String ticket = CommonHelper.substringBetween(logoutMessage, "SessionIndex>", "</");
            if (CommonHelper.isNotBlank(ticket)) {
                logoutHandler.destroySessionFront(context, sessionStore, ticket);
            }
            logger.debug("front logout request: no credential returned");
            this.throwFinalActionForFrontChannelLogout(context);
        }
        return Optional.empty();
    }

    protected boolean isTokenRequest(WebContext context) {
        return this.getArtifactParameter(context).isPresent();
    }

    protected Optional<String> getArtifactParameter(WebContext context) {
        Optional<String> optValue;
        if (this.configuration.getProtocol() == CasProtocol.SAML && (optValue = context.getRequestParameter(Protocol.SAML11.getArtifactParameterName())).isPresent()) {
            return optValue;
        }
        return context.getRequestParameter("ticket");
    }

    protected boolean isBackLogoutRequest(WebContext context) {
        return WebContextHelper.isPost(context) && !this.isMultipartRequest(context) && context.getRequestParameter("logoutRequest").isPresent();
    }

    protected boolean isMultipartRequest(WebContext context) {
        Optional<String> contentType = context.getRequestHeader("Content-Type");
        return contentType.isPresent() && contentType.get().toLowerCase().startsWith("multipart");
    }

    protected boolean isFrontLogoutRequest(WebContext context) {
        return WebContextHelper.isGet(context) && context.getRequestParameter("logoutRequest").isPresent();
    }

    protected String uncompressLogoutMessage(String originalMessage) {
        byte[] binaryMessage = Base64.getMimeDecoder().decode(originalMessage);
        Inflater decompresser = null;
        try {
            decompresser = new Inflater();
            decompresser.setInput(binaryMessage);
            byte[] result2 = new byte[binaryMessage.length * 10];
            int resultLength = decompresser.inflate(result2);
            String string2 = new String(result2, 0, resultLength, "UTF-8");
            return string2;
        }
        catch (Exception e2) {
            logger.error("Unable to decompress logout message", e2);
            throw new TechnicalException(e2);
        }
        finally {
            if (decompresser != null) {
                decompresser.end();
            }
        }
    }

    protected void throwFinalActionForFrontChannelLogout(WebContext context) {
        Optional<String> relayStateValue = context.getRequestParameter("RelayState");
        if (relayStateValue.isPresent()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append(this.configuration.getPrefixUrl());
            if (!this.configuration.getPrefixUrl().endsWith("/")) {
                buffer.append("/");
            }
            buffer.append("logout?_eventId=next&");
            buffer.append("RelayState");
            buffer.append("=");
            buffer.append(CommonHelper.urlEncode(relayStateValue.get()));
            String redirectUrl = buffer.toString();
            logger.debug("Redirection url to the CAS server: {}", (Object)redirectUrl);
            throw HttpActionHelper.buildRedirectUrlAction(context, redirectUrl);
        }
        throw new OkAction("");
    }
}

