/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.cas.credentials.authenticator;

import java.util.HashMap;
import java.util.Map;
import org.jasig.cas.client.authentication.AttributePrincipal;
import org.jasig.cas.client.validation.Assertion;
import org.jasig.cas.client.validation.TicketValidationException;
import org.pac4j.cas.config.CasConfiguration;
import org.pac4j.cas.profile.CasProfileDefinition;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.credentials.TokenCredentials;
import org.pac4j.core.credentials.authenticator.Authenticator;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.http.callback.CallbackUrlResolver;
import org.pac4j.core.http.url.UrlResolver;
import org.pac4j.core.profile.ProfileHelper;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.core.profile.definition.ProfileDefinitionAware;
import org.pac4j.core.util.CommonHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CasAuthenticator
extends ProfileDefinitionAware
implements Authenticator {
    private static final Logger logger = LoggerFactory.getLogger(CasAuthenticator.class);
    protected CasConfiguration configuration;
    protected String clientName;
    protected UrlResolver urlResolver;
    protected CallbackUrlResolver callbackUrlResolver;
    protected String callbackUrl;

    public CasAuthenticator(CasConfiguration configuration, String clientName, UrlResolver urlResolver, CallbackUrlResolver callbackUrlResolver, String callbackUrl) {
        this.configuration = configuration;
        this.clientName = clientName;
        this.urlResolver = urlResolver;
        this.callbackUrlResolver = callbackUrlResolver;
        this.callbackUrl = callbackUrl;
    }

    @Override
    protected void internalInit(boolean forceReinit) {
        CommonHelper.assertNotNull("urlResolver", this.urlResolver);
        CommonHelper.assertNotNull("callbackUrlResolver", this.callbackUrlResolver);
        CommonHelper.assertNotBlank("clientName", this.clientName);
        CommonHelper.assertNotBlank("callbackUrl", this.callbackUrl);
        CommonHelper.assertNotNull("configuration", this.configuration);
        this.defaultProfileDefinition(new CasProfileDefinition());
    }

    @Override
    public void validate(Credentials cred, WebContext context, SessionStore sessionStore) {
        this.init();
        TokenCredentials credentials = (TokenCredentials)cred;
        String ticket = credentials.getToken();
        try {
            String finalCallbackUrl = this.callbackUrlResolver.compute(this.urlResolver, this.callbackUrl, this.clientName, context);
            Assertion assertion = this.configuration.retrieveTicketValidator(context).validate(ticket, finalCallbackUrl);
            AttributePrincipal principal = assertion.getPrincipal();
            logger.debug("principal: {}", (Object)principal);
            String id = principal.getName();
            HashMap<String, Object> newPrincipalAttributes = new HashMap<String, Object>();
            HashMap<String, Object> newAuthenticationAttributes = new HashMap<String, Object>();
            Map<String, Object> oldPrincipalAttributes = principal.getAttributes();
            Map<String, Object> oldAuthenticationAttributes = assertion.getAttributes();
            if (oldPrincipalAttributes != null) {
                oldPrincipalAttributes.entrySet().stream().forEach(e2 -> newPrincipalAttributes.put((String)e2.getKey(), e2.getValue()));
            }
            if (oldAuthenticationAttributes != null) {
                oldAuthenticationAttributes.entrySet().stream().forEach(e2 -> newAuthenticationAttributes.put((String)e2.getKey(), e2.getValue()));
            }
            UserProfile profile = this.getProfileDefinition().newProfile(id, this.configuration.getProxyReceptor(), principal);
            profile.setId(ProfileHelper.sanitizeIdentifier(id));
            this.getProfileDefinition().convertAndAdd(profile, newPrincipalAttributes, newAuthenticationAttributes);
            logger.debug("profile returned by CAS: {}", (Object)profile);
            credentials.setUserProfile(profile);
        }
        catch (TicketValidationException e3) {
            String message = "cannot validate CAS ticket: " + ticket;
            throw new TechnicalException(message, e3);
        }
    }
}

