/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.cas.client.rest;

import org.pac4j.cas.client.rest.AbstractCasRestClient;
import org.pac4j.cas.config.CasConfiguration;
import org.pac4j.cas.credentials.authenticator.CasRestAuthenticator;
import org.pac4j.core.credentials.extractor.FormExtractor;
import org.pac4j.core.util.CommonHelper;

public class CasRestFormClient
extends AbstractCasRestClient {
    private String usernameParameter = "username";
    private String passwordParameter = "password";

    public CasRestFormClient() {
    }

    public CasRestFormClient(CasConfiguration configuration, String usernameParameter, String passwordParameter) {
        this.configuration = configuration;
        this.usernameParameter = usernameParameter;
        this.passwordParameter = passwordParameter;
    }

    @Override
    protected void internalInit(boolean forceReinit) {
        CommonHelper.assertNotBlank("usernameParameter", this.usernameParameter);
        CommonHelper.assertNotBlank("passwordParameter", this.passwordParameter);
        CommonHelper.assertNotNull("configuration", this.configuration);
        this.defaultCredentialsExtractor(new FormExtractor(this.usernameParameter, this.passwordParameter));
        this.defaultAuthenticator(new CasRestAuthenticator(this.configuration));
    }

    public String getUsernameParameter() {
        return this.usernameParameter;
    }

    public void setUsernameParameter(String usernameParameter) {
        this.usernameParameter = usernameParameter;
    }

    public String getPasswordParameter() {
        return this.passwordParameter;
    }

    public void setPasswordParameter(String passwordParameter) {
        this.passwordParameter = passwordParameter;
    }

    @Override
    public String toString() {
        return CommonHelper.toNiceString(this.getClass(), "name", this.getName(), "credentialsExtractor", this.getCredentialsExtractor(), "authenticator", this.getAuthenticator(), "profileCreator", this.getProfileCreator(), "authorizationGenerators", this.getAuthorizationGenerators(), "configuration", this.configuration, "usernameParameter", this.usernameParameter, "passwordParameter", this.passwordParameter);
    }
}

