/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.cas.client.rest;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import org.jasig.cas.client.authentication.AttributePrincipal;
import org.jasig.cas.client.validation.Assertion;
import org.jasig.cas.client.validation.TicketValidationException;
import org.pac4j.cas.config.CasConfiguration;
import org.pac4j.cas.profile.CasProfile;
import org.pac4j.cas.profile.CasRestProfile;
import org.pac4j.core.client.DirectClient;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.TokenCredentials;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.profile.ProfileHelper;
import org.pac4j.core.util.HttpUtils;

public abstract class AbstractCasRestClient
extends DirectClient {
    protected CasConfiguration configuration;

    public void destroyTicketGrantingTicket(CasRestProfile profile, WebContext context) {
        HttpURLConnection connection = null;
        try {
            URL endpointURL = new URL(this.configuration.computeFinalRestUrl(context));
            URL deleteURL = new URL(endpointURL, endpointURL.getPath() + "/" + profile.getTicketGrantingTicketId());
            connection = HttpUtils.openDeleteConnection(deleteURL);
            int responseCode = connection.getResponseCode();
            if (responseCode != 200) {
                throw new TechnicalException("TGT delete request for `" + profile + "` failed: " + HttpUtils.buildHttpErrorMessage(connection));
            }
        }
        catch (IOException e2) {
            try {
                throw new TechnicalException(e2);
            }
            catch (Throwable throwable) {
                HttpUtils.closeConnection(connection);
                throw throwable;
            }
        }
        HttpUtils.closeConnection(connection);
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TokenCredentials requestServiceTicket(String serviceURL, CasRestProfile profile, WebContext context) {
        HttpURLConnection connection = null;
        URL endpointURL = new URL(this.configuration.computeFinalRestUrl(context));
        URL ticketURL = new URL(endpointURL, endpointURL.getPath() + "/" + profile.getTicketGrantingTicketId());
        connection = HttpUtils.openPostConnection(ticketURL);
        String payload = HttpUtils.encodeQueryParam("service", serviceURL);
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter(connection.getOutputStream(), StandardCharsets.UTF_8));
        out.write(payload);
        out.close();
        int responseCode = connection.getResponseCode();
        if (responseCode != 200) throw new TechnicalException("Service ticket request for `" + profile + "` failed: " + HttpUtils.buildHttpErrorMessage(connection));
        BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));
        TokenCredentials tokenCredentials = new TokenCredentials(in.readLine());
        in.close();
        HttpUtils.closeConnection(connection);
        return tokenCredentials;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        try {
                            in.close();
                            throw throwable;
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (IOException e2) {
                        throw new TechnicalException(e2);
                    }
                }
                catch (Throwable throwable3) {
                    HttpUtils.closeConnection(connection);
                    throw throwable3;
                }
            }
        }
    }

    public CasProfile validateServiceTicket(String serviceURL, TokenCredentials ticket, WebContext context) {
        try {
            Assertion assertion = this.configuration.retrieveTicketValidator(context).validate(ticket.getToken(), serviceURL);
            AttributePrincipal principal = assertion.getPrincipal();
            CasProfile casProfile = new CasProfile();
            casProfile.setId(ProfileHelper.sanitizeIdentifier(principal.getName()));
            casProfile.addAttributes(principal.getAttributes());
            return casProfile;
        }
        catch (TicketValidationException e2) {
            throw new TechnicalException(e2);
        }
    }

    public CasConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(CasConfiguration configuration) {
        this.configuration = configuration;
    }
}

