/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.cas.client.direct;

import java.util.Optional;
import org.pac4j.cas.authorization.DefaultCasAuthorizationGenerator;
import org.pac4j.cas.config.CasConfiguration;
import org.pac4j.cas.credentials.authenticator.CasAuthenticator;
import org.pac4j.cas.redirect.CasRedirectionActionBuilder;
import org.pac4j.core.client.DirectClient;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.credentials.authenticator.Authenticator;
import org.pac4j.core.credentials.extractor.ParameterExtractor;
import org.pac4j.core.exception.CredentialsException;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.http.callback.CallbackUrlResolver;
import org.pac4j.core.http.callback.NoParameterCallbackUrlResolver;
import org.pac4j.core.http.url.DefaultUrlResolver;
import org.pac4j.core.http.url.UrlResolver;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.core.util.HttpActionHelper;

public class DirectCasClient
extends DirectClient {
    private CasConfiguration configuration;
    private UrlResolver urlResolver = new DefaultUrlResolver();
    private CallbackUrlResolver callbackUrlResolver = new NoParameterCallbackUrlResolver();

    public DirectCasClient() {
    }

    public DirectCasClient(CasConfiguration casConfiguration) {
        this.configuration = casConfiguration;
    }

    @Override
    protected void internalInit(boolean forceReinits) {
        CommonHelper.assertNotNull("configuration", this.configuration);
        CommonHelper.assertTrue(!this.configuration.isGateway(), "the DirectCasClient can not support gateway to avoid infinite loops");
        this.defaultCredentialsExtractor(new ParameterExtractor("ticket", true, false));
        super.defaultAuthenticator(new CasAuthenticator(this.configuration, this.getName(), this.urlResolver, this.callbackUrlResolver, "fake"));
        this.addAuthorizationGenerator(new DefaultCasAuthorizationGenerator());
    }

    @Override
    protected Optional<Credentials> retrieveCredentials(WebContext context, SessionStore sessionStore) {
        this.init();
        try {
            String callbackUrl = this.callbackUrlResolver.compute(this.urlResolver, context.getFullRequestURL(), this.getName(), context);
            String loginUrl = this.configuration.computeFinalLoginUrl(context);
            Optional<Credentials> credentials = this.getCredentialsExtractor().extract(context, sessionStore);
            if (!credentials.isPresent()) {
                String redirectionUrl = CasRedirectionActionBuilder.constructRedirectUrl(loginUrl, "service", callbackUrl, this.configuration.isRenew(), false, null);
                this.logger.debug("redirectionUrl: {}", (Object)redirectionUrl);
                throw HttpActionHelper.buildRedirectUrlAction(context, redirectionUrl);
            }
            callbackUrl = CommonHelper.substringBefore(callbackUrl, "?ticket=");
            callbackUrl = CommonHelper.substringBefore(callbackUrl, "&ticket=");
            CasAuthenticator casAuthenticator = new CasAuthenticator(this.configuration, this.getName(), this.urlResolver, this.callbackUrlResolver, callbackUrl);
            casAuthenticator.init();
            casAuthenticator.validate(credentials.get(), context, sessionStore);
            return credentials;
        }
        catch (CredentialsException e2) {
            this.logger.error("Failed to retrieve or validate CAS credentials", e2);
            return Optional.empty();
        }
    }

    @Override
    protected void defaultAuthenticator(Authenticator authenticator) {
        throw new TechnicalException("You can not set an Authenticator for the DirectCasClient at startup. A new CasAuthenticator is automatically created for each request");
    }

    public CasConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(CasConfiguration configuration) {
        this.configuration = configuration;
    }

    public UrlResolver getUrlResolver() {
        return this.urlResolver;
    }

    public void setUrlResolver(UrlResolver urlResolver) {
        this.urlResolver = urlResolver;
    }

    public CallbackUrlResolver getCallbackUrlResolver() {
        return this.callbackUrlResolver;
    }

    public void setCallbackUrlResolver(CallbackUrlResolver callbackUrlResolver) {
        this.callbackUrlResolver = callbackUrlResolver;
    }

    @Override
    public String toString() {
        return CommonHelper.toNiceString(this.getClass(), "name", this.getName(), "credentialsExtractor", this.getCredentialsExtractor(), "authenticator", this.getAuthenticator(), "profileCreator", this.getProfileCreator(), "authorizationGenerators", this.getAuthorizationGenerators(), "configuration", this.configuration, "urlResolver", this.urlResolver, "callbackUrlResolver", this.callbackUrlResolver);
    }
}

