/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.cas.authorization;

import java.util.Optional;
import org.pac4j.core.authorization.generator.AuthorizationGenerator;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.profile.UserProfile;

public class DefaultCasAuthorizationGenerator
implements AuthorizationGenerator {
    public static final String DEFAULT_REMEMBER_ME_ATTRIBUTE_NAME = "longTermAuthenticationRequestTokenUsed";
    protected String rememberMeAttributeName = "longTermAuthenticationRequestTokenUsed";

    public DefaultCasAuthorizationGenerator() {
    }

    public DefaultCasAuthorizationGenerator(String rememberMeAttributeName) {
        this.rememberMeAttributeName = rememberMeAttributeName;
    }

    @Override
    public Optional<UserProfile> generate(WebContext context, SessionStore sessionStore, UserProfile profile) {
        String rememberMeValue = (String)profile.getAttribute(this.rememberMeAttributeName);
        boolean isRemembered = rememberMeValue != null && Boolean.parseBoolean(rememberMeValue);
        profile.setRemembered(isRemembered);
        return Optional.of(profile);
    }
}

