/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.client.validation.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;
import org.jasig.cas.client.authentication.AttributePrincipalImpl;
import org.jasig.cas.client.proxy.ProxyGrantingTicketStorage;
import org.jasig.cas.client.proxy.ProxyRetriever;
import org.jasig.cas.client.util.CommonUtils;
import org.jasig.cas.client.validation.Assertion;
import org.jasig.cas.client.validation.AssertionImpl;

final class TicketValidationJsonResponse {
    private final CasServiceResponseAuthentication serviceResponse;

    @JsonCreator
    public TicketValidationJsonResponse(@JsonProperty(value="serviceResponse") CasServiceResponseAuthentication serviceResponse) {
        this.serviceResponse = serviceResponse;
    }

    public CasServiceResponseAuthentication getServiceResponse() {
        return this.serviceResponse;
    }

    Assertion getAssertion(ProxyGrantingTicketStorage proxyGrantingTicketStorage, ProxyRetriever proxyRetriever) {
        AssertionImpl assertion;
        String proxyGrantingTicketIou = this.getServiceResponse().getAuthenticationSuccess().getProxyGrantingTicket();
        String proxyGrantingTicket = CommonUtils.isBlank(proxyGrantingTicketIou) || proxyGrantingTicketStorage == null ? null : proxyGrantingTicketStorage.retrieve(proxyGrantingTicketIou);
        Map attributes = this.getServiceResponse().getAuthenticationSuccess().getAttributes();
        String principal = this.getServiceResponse().getAuthenticationSuccess().getUser();
        if (CommonUtils.isNotBlank(proxyGrantingTicket)) {
            AttributePrincipalImpl attributePrincipal = new AttributePrincipalImpl(principal, attributes, proxyGrantingTicket, proxyRetriever);
            assertion = new AssertionImpl(attributePrincipal);
        } else {
            assertion = new AssertionImpl(new AttributePrincipalImpl(principal, attributes));
        }
        return assertion;
    }

    static class CasServiceResponseAuthenticationFailure {
        private String code;
        private String description;

        CasServiceResponseAuthenticationFailure() {
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description2) {
            this.description = description2;
        }
    }

    static class CasServiceResponseAuthenticationSuccess {
        private String user;
        private String proxyGrantingTicket;
        private List proxies;
        private Map attributes;

        CasServiceResponseAuthenticationSuccess() {
        }

        public String getUser() {
            return this.user;
        }

        public void setUser(String user) {
            this.user = user;
        }

        public String getProxyGrantingTicket() {
            return this.proxyGrantingTicket;
        }

        public void setProxyGrantingTicket(String proxyGrantingTicket) {
            this.proxyGrantingTicket = proxyGrantingTicket;
        }

        public List getProxies() {
            return this.proxies;
        }

        public void setProxies(List proxies) {
            this.proxies = proxies;
        }

        public Map getAttributes() {
            return this.attributes;
        }

        public void setAttributes(Map attributes) {
            this.attributes = attributes;
        }
    }

    static class CasServiceResponseAuthentication {
        private final CasServiceResponseAuthenticationFailure authenticationFailure;
        private final CasServiceResponseAuthenticationSuccess authenticationSuccess;

        @JsonCreator
        public CasServiceResponseAuthentication(@JsonProperty(value="authenticationFailure") CasServiceResponseAuthenticationFailure authenticationFailure, @JsonProperty(value="authenticationSuccess") CasServiceResponseAuthenticationSuccess authenticationSuccess) {
            this.authenticationFailure = authenticationFailure;
            this.authenticationSuccess = authenticationSuccess;
        }

        public CasServiceResponseAuthenticationFailure getAuthenticationFailure() {
            return this.authenticationFailure;
        }

        public CasServiceResponseAuthenticationSuccess getAuthenticationSuccess() {
            return this.authenticationSuccess;
        }
    }
}

